/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.SpartaProxyVpcEndpoint;
import software.amazon.awssdk.services.redshift.model.SpartaProxyVpcEndpointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Endpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Endpoint> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(Endpoint.getter(Endpoint::address)).setter(Endpoint.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(Endpoint.getter(Endpoint::port)).setter(Endpoint.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<List<SpartaProxyVpcEndpoint>> VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcEndpoints").getter(Endpoint.getter(Endpoint::vpcEndpoints)).setter(Endpoint.setter(Builder::vpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoints").build(), ListTrait.builder().memberLocationName("SpartaProxyVpcEndpoint").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpartaProxyVpcEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpartaProxyVpcEndpoint").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, PORT_FIELD, VPC_ENDPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String address;
    private final Integer port;
    private final List<SpartaProxyVpcEndpoint> vpcEndpoints;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.port = builder.port;
        this.vpcEndpoints = builder.vpcEndpoints;
    }

    public String address() {
        return this.address;
    }

    public Integer port() {
        return this.port;
    }

    public boolean hasVpcEndpoints() {
        return this.vpcEndpoints != null && !(this.vpcEndpoints instanceof SdkAutoConstructList);
    }

    public List<SpartaProxyVpcEndpoint> vpcEndpoints() {
        return this.vpcEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpoints() ? this.vpcEndpoints() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.port(), other.port()) && this.hasVpcEndpoints() == other.hasVpcEndpoints() && Objects.equals(this.vpcEndpoints(), other.vpcEndpoints());
    }

    public String toString() {
        return ToString.builder((String)"Endpoint").add("Address", (Object)this.address()).add("Port", (Object)this.port()).add("VpcEndpoints", this.hasVpcEndpoints() ? this.vpcEndpoints() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "VpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private Integer port;
        private List<SpartaProxyVpcEndpoint> vpcEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.address(model.address);
            this.port(model.port);
            this.vpcEndpoints(model.vpcEndpoints);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Collection<SpartaProxyVpcEndpoint.Builder> getVpcEndpoints() {
            if (this.vpcEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcEndpoints != null ? (Collection)this.vpcEndpoints.stream().map(SpartaProxyVpcEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcEndpoints(Collection<SpartaProxyVpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = SpartaProxyVpcEndpointListCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(SpartaProxyVpcEndpoint ... vpcEndpoints) {
            this.vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(Consumer<SpartaProxyVpcEndpoint.Builder> ... vpcEndpoints) {
            this.vpcEndpoints(Stream.of(vpcEndpoints).map(c -> (SpartaProxyVpcEndpoint)((SpartaProxyVpcEndpoint.Builder)SpartaProxyVpcEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcEndpoints(Collection<SpartaProxyVpcEndpoint.BuilderImpl> vpcEndpoints) {
            this.vpcEndpoints = SpartaProxyVpcEndpointListCopier.copyFromBuilder(vpcEndpoints);
        }

        public Endpoint build() {
            return new Endpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Endpoint> {
        public Builder address(String var1);

        public Builder port(Integer var1);

        public Builder vpcEndpoints(Collection<SpartaProxyVpcEndpoint> var1);

        public Builder vpcEndpoints(SpartaProxyVpcEndpoint ... var1);

        public Builder vpcEndpoints(Consumer<SpartaProxyVpcEndpoint.Builder> ... var1);
    }
}

