/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.SnapshotAttributeToSortBy;
import software.amazon.awssdk.services.redshift.model.SortByOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotSortingEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotSortingEntity> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(SnapshotSortingEntity.getter(SnapshotSortingEntity::attributeAsString)).setter(SnapshotSortingEntity.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(SnapshotSortingEntity.getter(SnapshotSortingEntity::sortOrderAsString)).setter(SnapshotSortingEntity.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, SORT_ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final String sortOrder;

    private SnapshotSortingEntity(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.sortOrder = builder.sortOrder;
    }

    public SnapshotAttributeToSortBy attribute() {
        return SnapshotAttributeToSortBy.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    public SortByOrder sortOrder() {
        return SortByOrder.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotSortingEntity)) {
            return false;
        }
        SnapshotSortingEntity other = (SnapshotSortingEntity)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public String toString() {
        return ToString.builder((String)"SnapshotSortingEntity").add("Attribute", (Object)this.attributeAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotSortingEntity, T> g) {
        return obj -> g.apply((SnapshotSortingEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotSortingEntity model) {
            this.attribute(model.attribute);
            this.sortOrder(model.sortOrder);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeToSortBy attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortByOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public SnapshotSortingEntity build() {
            return new SnapshotSortingEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotSortingEntity> {
        public Builder attribute(String var1);

        public Builder attribute(SnapshotAttributeToSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortByOrder var1);
    }
}

