/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2SecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2SecurityGroup> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EC2SecurityGroup.getter(EC2SecurityGroup::status)).setter(EC2SecurityGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2SecurityGroupName").getter(EC2SecurityGroup.getter(EC2SecurityGroup::ec2SecurityGroupName)).setter(EC2SecurityGroup.setter(Builder::ec2SecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupName").build()}).build();
    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2SecurityGroupOwnerId").getter(EC2SecurityGroup.getter(EC2SecurityGroup::ec2SecurityGroupOwnerId)).setter(EC2SecurityGroup.setter(Builder::ec2SecurityGroupOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupOwnerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(EC2SecurityGroup.getter(EC2SecurityGroup::tags)).setter(EC2SecurityGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String ec2SecurityGroupName;
    private final String ec2SecurityGroupOwnerId;
    private final List<Tag> tags;

    private EC2SecurityGroup(BuilderImpl builder) {
        this.status = builder.status;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
        this.tags = builder.tags;
    }

    public String status() {
        return this.status;
    }

    public String ec2SecurityGroupName() {
        return this.ec2SecurityGroupName;
    }

    public String ec2SecurityGroupOwnerId() {
        return this.ec2SecurityGroupOwnerId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2SecurityGroup)) {
            return false;
        }
        EC2SecurityGroup other = (EC2SecurityGroup)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.ec2SecurityGroupName(), other.ec2SecurityGroupName()) && Objects.equals(this.ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"EC2SecurityGroup").add("Status", (Object)this.status()).add("EC2SecurityGroupName", (Object)this.ec2SecurityGroupName()).add("EC2SecurityGroupOwnerId", (Object)this.ec2SecurityGroupOwnerId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "EC2SecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupName()));
            }
            case "EC2SecurityGroupOwnerId": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupOwnerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2SecurityGroup, T> g) {
        return obj -> g.apply((EC2SecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String ec2SecurityGroupName;
        private String ec2SecurityGroupOwnerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EC2SecurityGroup model) {
            this.status(model.status);
            this.ec2SecurityGroupName(model.ec2SecurityGroupName);
            this.ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
            this.tags(model.tags);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEc2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public EC2SecurityGroup build() {
            return new EC2SecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2SecurityGroup> {
        public Builder status(String var1);

        public Builder ec2SecurityGroupName(String var1);

        public Builder ec2SecurityGroupOwnerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

