/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.ParameterApplyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(Parameter.getter(Parameter::parameterName)).setter(Parameter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterValue").getter(Parameter.getter(Parameter::parameterValue)).setter(Parameter.setter(Builder::parameterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Parameter.getter(Parameter::description)).setter(Parameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Parameter.getter(Parameter::source)).setter(Parameter.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(Parameter.getter(Parameter::dataType)).setter(Parameter.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedValues").getter(Parameter.getter(Parameter::allowedValues)).setter(Parameter.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()}).build();
    private static final SdkField<String> APPLY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplyType").getter(Parameter.getter(Parameter::applyTypeAsString)).setter(Parameter.setter(Builder::applyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyType").build()}).build();
    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsModifiable").getter(Parameter.getter(Parameter::isModifiable)).setter(Parameter.setter(Builder::isModifiable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()}).build();
    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumEngineVersion").getter(Parameter.getter(Parameter::minimumEngineVersion)).setter(Parameter.setter(Builder::minimumEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD, PARAMETER_VALUE_FIELD, DESCRIPTION_FIELD, SOURCE_FIELD, DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD, APPLY_TYPE_FIELD, IS_MODIFIABLE_FIELD, MINIMUM_ENGINE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterName;
    private final String parameterValue;
    private final String description;
    private final String source;
    private final String dataType;
    private final String allowedValues;
    private final String applyType;
    private final Boolean isModifiable;
    private final String minimumEngineVersion;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.applyType = builder.applyType;
        this.isModifiable = builder.isModifiable;
        this.minimumEngineVersion = builder.minimumEngineVersion;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public String description() {
        return this.description;
    }

    public String source() {
        return this.source;
    }

    public String dataType() {
        return this.dataType;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public ParameterApplyType applyType() {
        return ParameterApplyType.fromValue(this.applyType);
    }

    public String applyTypeAsString() {
        return this.applyType;
    }

    public Boolean isModifiable() {
        return this.isModifiable;
    }

    public String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumEngineVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.parameterValue(), other.parameterValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.applyTypeAsString(), other.applyTypeAsString()) && Objects.equals(this.isModifiable(), other.isModifiable()) && Objects.equals(this.minimumEngineVersion(), other.minimumEngineVersion());
    }

    public String toString() {
        return ToString.builder((String)"Parameter").add("ParameterName", (Object)this.parameterName()).add("ParameterValue", (Object)this.parameterValue()).add("Description", (Object)this.description()).add("Source", (Object)this.source()).add("DataType", (Object)this.dataType()).add("AllowedValues", (Object)this.allowedValues()).add("ApplyType", (Object)this.applyTypeAsString()).add("IsModifiable", (Object)this.isModifiable()).add("MinimumEngineVersion", (Object)this.minimumEngineVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "ParameterValue": {
                return Optional.ofNullable(clazz.cast(this.parameterValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "ApplyType": {
                return Optional.ofNullable(clazz.cast(this.applyTypeAsString()));
            }
            case "IsModifiable": {
                return Optional.ofNullable(clazz.cast(this.isModifiable()));
            }
            case "MinimumEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumEngineVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterValue;
        private String description;
        private String source;
        private String dataType;
        private String allowedValues;
        private String applyType;
        private Boolean isModifiable;
        private String minimumEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.parameterName(model.parameterName);
            this.parameterValue(model.parameterValue);
            this.description(model.description);
            this.source(model.source);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.applyType(model.applyType);
            this.isModifiable(model.isModifiable);
            this.minimumEngineVersion(model.minimumEngineVersion);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final String getApplyType() {
            return this.applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        @Override
        public final Builder applyType(ParameterApplyType applyType) {
            this.applyType(applyType == null ? null : applyType.toString());
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final Boolean getIsModifiable() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        public Parameter build() {
            return new Parameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameter> {
        public Builder parameterName(String var1);

        public Builder parameterValue(String var1);

        public Builder description(String var1);

        public Builder source(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder applyType(String var1);

        public Builder applyType(ParameterApplyType var1);

        public Builder isModifiable(Boolean var1);

        public Builder minimumEngineVersion(String var1);
    }
}

