/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction;
import software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType;
import software.amazon.awssdk.services.redshift.model.UsageLimitLimitType;
import software.amazon.awssdk.services.redshift.model.UsageLimitPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUsageLimitResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, CreateUsageLimitResponse> {
    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageLimitId").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::usageLimitId)).setter(CreateUsageLimitResponse.setter(Builder::usageLimitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageLimitId").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::clusterIdentifier)).setter(CreateUsageLimitResponse.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> FEATURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureType").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::featureTypeAsString)).setter(CreateUsageLimitResponse.setter(Builder::featureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureType").build()}).build();
    private static final SdkField<String> LIMIT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LimitType").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::limitTypeAsString)).setter(CreateUsageLimitResponse.setter(Builder::limitType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitType").build()}).build();
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Amount").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::amount)).setter(CreateUsageLimitResponse.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Period").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::periodAsString)).setter(CreateUsageLimitResponse.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BreachAction").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::breachActionAsString)).setter(CreateUsageLimitResponse.setter(Builder::breachAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BreachAction").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateUsageLimitResponse.getter(CreateUsageLimitResponse::tags)).setter(CreateUsageLimitResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_LIMIT_ID_FIELD, CLUSTER_IDENTIFIER_FIELD, FEATURE_TYPE_FIELD, LIMIT_TYPE_FIELD, AMOUNT_FIELD, PERIOD_FIELD, BREACH_ACTION_FIELD, TAGS_FIELD));
    private final String usageLimitId;
    private final String clusterIdentifier;
    private final String featureType;
    private final String limitType;
    private final Long amount;
    private final String period;
    private final String breachAction;
    private final List<Tag> tags;

    private CreateUsageLimitResponse(BuilderImpl builder) {
        super(builder);
        this.usageLimitId = builder.usageLimitId;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.featureType = builder.featureType;
        this.limitType = builder.limitType;
        this.amount = builder.amount;
        this.period = builder.period;
        this.breachAction = builder.breachAction;
        this.tags = builder.tags;
    }

    public String usageLimitId() {
        return this.usageLimitId;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public UsageLimitFeatureType featureType() {
        return UsageLimitFeatureType.fromValue(this.featureType);
    }

    public String featureTypeAsString() {
        return this.featureType;
    }

    public UsageLimitLimitType limitType() {
        return UsageLimitLimitType.fromValue(this.limitType);
    }

    public String limitTypeAsString() {
        return this.limitType;
    }

    public Long amount() {
        return this.amount;
    }

    public UsageLimitPeriod period() {
        return UsageLimitPeriod.fromValue(this.period);
    }

    public String periodAsString() {
        return this.period;
    }

    public UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(this.breachAction);
    }

    public String breachActionAsString() {
        return this.breachAction;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.usageLimitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUsageLimitResponse)) {
            return false;
        }
        CreateUsageLimitResponse other = (CreateUsageLimitResponse)((Object)obj);
        return Objects.equals(this.usageLimitId(), other.usageLimitId()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.featureTypeAsString(), other.featureTypeAsString()) && Objects.equals(this.limitTypeAsString(), other.limitTypeAsString()) && Objects.equals(this.amount(), other.amount()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.breachActionAsString(), other.breachActionAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateUsageLimitResponse").add("UsageLimitId", (Object)this.usageLimitId()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("FeatureType", (Object)this.featureTypeAsString()).add("LimitType", (Object)this.limitTypeAsString()).add("Amount", (Object)this.amount()).add("Period", (Object)this.periodAsString()).add("BreachAction", (Object)this.breachActionAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageLimitId": {
                return Optional.ofNullable(clazz.cast(this.usageLimitId()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "FeatureType": {
                return Optional.ofNullable(clazz.cast(this.featureTypeAsString()));
            }
            case "LimitType": {
                return Optional.ofNullable(clazz.cast(this.limitTypeAsString()));
            }
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "BreachAction": {
                return Optional.ofNullable(clazz.cast(this.breachActionAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUsageLimitResponse, T> g) {
        return obj -> g.apply((CreateUsageLimitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String usageLimitId;
        private String clusterIdentifier;
        private String featureType;
        private String limitType;
        private Long amount;
        private String period;
        private String breachAction;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUsageLimitResponse model) {
            super(model);
            this.usageLimitId(model.usageLimitId);
            this.clusterIdentifier(model.clusterIdentifier);
            this.featureType(model.featureType);
            this.limitType(model.limitType);
            this.amount(model.amount);
            this.period(model.period);
            this.breachAction(model.breachAction);
            this.tags(model.tags);
        }

        public final String getUsageLimitId() {
            return this.usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getFeatureType() {
            return this.featureType;
        }

        @Override
        public final Builder featureType(String featureType) {
            this.featureType = featureType;
            return this;
        }

        @Override
        public final Builder featureType(UsageLimitFeatureType featureType) {
            this.featureType(featureType == null ? null : featureType.toString());
            return this;
        }

        public final void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        public final String getLimitType() {
            return this.limitType;
        }

        @Override
        public final Builder limitType(String limitType) {
            this.limitType = limitType;
            return this;
        }

        @Override
        public final Builder limitType(UsageLimitLimitType limitType) {
            this.limitType(limitType == null ? null : limitType.toString());
            return this;
        }

        public final void setLimitType(String limitType) {
            this.limitType = limitType;
        }

        public final Long getAmount() {
            return this.amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        public final String getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(UsageLimitPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        public final String getBreachAction() {
            return this.breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public CreateUsageLimitResponse build() {
            return new CreateUsageLimitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUsageLimitResponse> {
        public Builder usageLimitId(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder featureType(String var1);

        public Builder featureType(UsageLimitFeatureType var1);

        public Builder limitType(String var1);

        public Builder limitType(UsageLimitLimitType var1);

        public Builder amount(Long var1);

        public Builder period(String var1);

        public Builder period(UsageLimitPeriod var1);

        public Builder breachAction(String var1);

        public Builder breachAction(UsageLimitBreachAction var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

