/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A maintenance track that you can switch the current track to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTarget implements SdkPojo, Serializable, ToCopyableBuilder<UpdateTarget.Builder, UpdateTarget> {
    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTarget::maintenanceTrackName)).setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<String> DATABASE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTarget::databaseVersion)).setter(setter(Builder::databaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseVersion").build()).build();

    private static final SdkField<List<SupportedOperation>> SUPPORTED_OPERATIONS_FIELD = SdkField
            .<List<SupportedOperation>> builder(MarshallingType.LIST)
            .getter(getter(UpdateTarget::supportedOperations))
            .setter(setter(Builder::supportedOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SupportedOperation")
                            .memberFieldInfo(
                                    SdkField.<SupportedOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SupportedOperation").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_TRACK_NAME_FIELD,
            DATABASE_VERSION_FIELD, SUPPORTED_OPERATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String maintenanceTrackName;

    private final String databaseVersion;

    private final List<SupportedOperation> supportedOperations;

    private UpdateTarget(BuilderImpl builder) {
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.databaseVersion = builder.databaseVersion;
        this.supportedOperations = builder.supportedOperations;
    }

    /**
     * <p>
     * The name of the new maintenance track.
     * </p>
     * 
     * @return The name of the new maintenance track.
     */
    public String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * The cluster version for the new maintenance track.
     * </p>
     * 
     * @return The cluster version for the new maintenance track.
     */
    public String databaseVersion() {
        return databaseVersion;
    }

    /**
     * Returns true if the SupportedOperations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSupportedOperations() {
        return supportedOperations != null && !(supportedOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of operations supported by the maintenance track.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of operations supported by the maintenance track.
     */
    public List<SupportedOperation> supportedOperations() {
        return supportedOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(supportedOperations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTarget)) {
            return false;
        }
        UpdateTarget other = (UpdateTarget) obj;
        return Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(databaseVersion(), other.databaseVersion())
                && Objects.equals(supportedOperations(), other.supportedOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTarget").add("MaintenanceTrackName", maintenanceTrackName())
                .add("DatabaseVersion", databaseVersion()).add("SupportedOperations", supportedOperations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "DatabaseVersion":
            return Optional.ofNullable(clazz.cast(databaseVersion()));
        case "SupportedOperations":
            return Optional.ofNullable(clazz.cast(supportedOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTarget, T> g) {
        return obj -> g.apply((UpdateTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateTarget> {
        /**
         * <p>
         * The name of the new maintenance track.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the new maintenance track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * The cluster version for the new maintenance track.
         * </p>
         * 
         * @param databaseVersion
         *        The cluster version for the new maintenance track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseVersion(String databaseVersion);

        /**
         * <p>
         * A list of operations supported by the maintenance track.
         * </p>
         * 
         * @param supportedOperations
         *        A list of operations supported by the maintenance track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperations(Collection<SupportedOperation> supportedOperations);

        /**
         * <p>
         * A list of operations supported by the maintenance track.
         * </p>
         * 
         * @param supportedOperations
         *        A list of operations supported by the maintenance track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedOperations(SupportedOperation... supportedOperations);

        /**
         * <p>
         * A list of operations supported by the maintenance track.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SupportedOperation>.Builder} avoiding the
         * need to create one manually via {@link List<SupportedOperation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SupportedOperation>.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedOperations(List<SupportedOperation>)}.
         * 
         * @param supportedOperations
         *        a consumer that will call methods on {@link List<SupportedOperation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedOperations(List<SupportedOperation>)
         */
        Builder supportedOperations(Consumer<SupportedOperation.Builder>... supportedOperations);
    }

    static final class BuilderImpl implements Builder {
        private String maintenanceTrackName;

        private String databaseVersion;

        private List<SupportedOperation> supportedOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTarget model) {
            maintenanceTrackName(model.maintenanceTrackName);
            databaseVersion(model.databaseVersion);
            supportedOperations(model.supportedOperations);
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final String getDatabaseVersion() {
            return databaseVersion;
        }

        @Override
        public final Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public final void setDatabaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
        }

        public final Collection<SupportedOperation.Builder> getSupportedOperations() {
            return supportedOperations != null ? supportedOperations.stream().map(SupportedOperation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedOperations(Collection<SupportedOperation> supportedOperations) {
            this.supportedOperations = SupportedOperationListCopier.copy(supportedOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperations(SupportedOperation... supportedOperations) {
            supportedOperations(Arrays.asList(supportedOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOperations(Consumer<SupportedOperation.Builder>... supportedOperations) {
            supportedOperations(Stream.of(supportedOperations).map(c -> SupportedOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedOperations(Collection<SupportedOperation.BuilderImpl> supportedOperations) {
            this.supportedOperations = SupportedOperationListCopier.copyFromBuilder(supportedOperations);
        }

        @Override
        public UpdateTarget build() {
            return new UpdateTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
