/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a <a>RestoreTableFromClusterSnapshot</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableRestoreStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<TableRestoreStatus.Builder, TableRestoreStatus> {
    private static final SdkField<String> TABLE_RESTORE_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::tableRestoreRequestId)).setter(setter(Builder::tableRestoreRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableRestoreRequestId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TableRestoreStatus::requestTime)).setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()).build();

    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableRestoreStatus::progressInMegaBytes)).setter(setter(Builder::progressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build())
            .build();

    private static final SdkField<Long> TOTAL_DATA_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableRestoreStatus::totalDataInMegaBytes)).setter(setter(Builder::totalDataInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalDataInMegaBytes").build())
            .build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::snapshotIdentifier)).setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::sourceDatabaseName)).setter(setter(Builder::sourceDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDatabaseName").build())
            .build();

    private static final SdkField<String> SOURCE_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::sourceSchemaName)).setter(setter(Builder::sourceSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSchemaName").build()).build();

    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::sourceTableName)).setter(setter(Builder::sourceTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableName").build()).build();

    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::targetDatabaseName)).setter(setter(Builder::targetDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabaseName").build())
            .build();

    private static final SdkField<String> TARGET_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::targetSchemaName)).setter(setter(Builder::targetSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSchemaName").build()).build();

    private static final SdkField<String> NEW_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableRestoreStatus::newTableName)).setter(setter(Builder::newTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewTableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TABLE_RESTORE_REQUEST_ID_FIELD, STATUS_FIELD, MESSAGE_FIELD, REQUEST_TIME_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD,
            TOTAL_DATA_IN_MEGA_BYTES_FIELD, CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, SOURCE_DATABASE_NAME_FIELD,
            SOURCE_SCHEMA_NAME_FIELD, SOURCE_TABLE_NAME_FIELD, TARGET_DATABASE_NAME_FIELD, TARGET_SCHEMA_NAME_FIELD,
            NEW_TABLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableRestoreRequestId;

    private final String status;

    private final String message;

    private final Instant requestTime;

    private final Long progressInMegaBytes;

    private final Long totalDataInMegaBytes;

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final String sourceDatabaseName;

    private final String sourceSchemaName;

    private final String sourceTableName;

    private final String targetDatabaseName;

    private final String targetSchemaName;

    private final String newTableName;

    private TableRestoreStatus(BuilderImpl builder) {
        this.tableRestoreRequestId = builder.tableRestoreRequestId;
        this.status = builder.status;
        this.message = builder.message;
        this.requestTime = builder.requestTime;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.totalDataInMegaBytes = builder.totalDataInMegaBytes;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.newTableName = builder.newTableName;
    }

    /**
     * <p>
     * The unique identifier for the table restore request.
     * </p>
     * 
     * @return The unique identifier for the table restore request.
     */
    public String tableRestoreRequestId() {
        return tableRestoreRequestId;
    }

    /**
     * <p>
     * A value that describes the current state of the table restore request.
     * </p>
     * <p>
     * Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>,
     * <code>IN_PROGRESS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableRestoreStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A value that describes the current state of the table restore request.</p>
     *         <p>
     *         Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>,
     *         <code>IN_PROGRESS</code>
     * @see TableRestoreStatusType
     */
    public TableRestoreStatusType status() {
        return TableRestoreStatusType.fromValue(status);
    }

    /**
     * <p>
     * A value that describes the current state of the table restore request.
     * </p>
     * <p>
     * Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>,
     * <code>IN_PROGRESS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TableRestoreStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A value that describes the current state of the table restore request.</p>
     *         <p>
     *         Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>,
     *         <code>IN_PROGRESS</code>
     * @see TableRestoreStatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>,
     * <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.
     * </p>
     * 
     * @return A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>,
     *         <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The time that the table restore request was made, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The time that the table restore request was made, in Universal Coordinated Time (UTC).
     */
    public Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * The amount of data restored to the new table so far, in megabytes (MB).
     * </p>
     * 
     * @return The amount of data restored to the new table so far, in megabytes (MB).
     */
    public Long progressInMegaBytes() {
        return progressInMegaBytes;
    }

    /**
     * <p>
     * The total amount of data to restore to the new table, in megabytes (MB).
     * </p>
     * 
     * @return The total amount of data to restore to the new table, in megabytes (MB).
     */
    public Long totalDataInMegaBytes() {
        return totalDataInMegaBytes;
    }

    /**
     * <p>
     * The identifier of the Amazon Redshift cluster that the table is being restored to.
     * </p>
     * 
     * @return The identifier of the Amazon Redshift cluster that the table is being restored to.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the snapshot that the table is being restored from.
     * </p>
     * 
     * @return The identifier of the snapshot that the table is being restored from.
     */
    public String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The name of the source database that contains the table being restored.
     * </p>
     * 
     * @return The name of the source database that contains the table being restored.
     */
    public String sourceDatabaseName() {
        return sourceDatabaseName;
    }

    /**
     * <p>
     * The name of the source schema that contains the table being restored.
     * </p>
     * 
     * @return The name of the source schema that contains the table being restored.
     */
    public String sourceSchemaName() {
        return sourceSchemaName;
    }

    /**
     * <p>
     * The name of the source table being restored.
     * </p>
     * 
     * @return The name of the source table being restored.
     */
    public String sourceTableName() {
        return sourceTableName;
    }

    /**
     * <p>
     * The name of the database to restore the table to.
     * </p>
     * 
     * @return The name of the database to restore the table to.
     */
    public String targetDatabaseName() {
        return targetDatabaseName;
    }

    /**
     * <p>
     * The name of the schema to restore the table to.
     * </p>
     * 
     * @return The name of the schema to restore the table to.
     */
    public String targetSchemaName() {
        return targetSchemaName;
    }

    /**
     * <p>
     * The name of the table to create as a result of the table restore request.
     * </p>
     * 
     * @return The name of the table to create as a result of the table restore request.
     */
    public String newTableName() {
        return newTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableRestoreRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(totalDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(targetSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(newTableName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRestoreStatus)) {
            return false;
        }
        TableRestoreStatus other = (TableRestoreStatus) obj;
        return Objects.equals(tableRestoreRequestId(), other.tableRestoreRequestId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(requestTime(), other.requestTime())
                && Objects.equals(progressInMegaBytes(), other.progressInMegaBytes())
                && Objects.equals(totalDataInMegaBytes(), other.totalDataInMegaBytes())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(sourceDatabaseName(), other.sourceDatabaseName())
                && Objects.equals(sourceSchemaName(), other.sourceSchemaName())
                && Objects.equals(sourceTableName(), other.sourceTableName())
                && Objects.equals(targetDatabaseName(), other.targetDatabaseName())
                && Objects.equals(targetSchemaName(), other.targetSchemaName())
                && Objects.equals(newTableName(), other.newTableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TableRestoreStatus").add("TableRestoreRequestId", tableRestoreRequestId())
                .add("Status", statusAsString()).add("Message", message()).add("RequestTime", requestTime())
                .add("ProgressInMegaBytes", progressInMegaBytes()).add("TotalDataInMegaBytes", totalDataInMegaBytes())
                .add("ClusterIdentifier", clusterIdentifier()).add("SnapshotIdentifier", snapshotIdentifier())
                .add("SourceDatabaseName", sourceDatabaseName()).add("SourceSchemaName", sourceSchemaName())
                .add("SourceTableName", sourceTableName()).add("TargetDatabaseName", targetDatabaseName())
                .add("TargetSchemaName", targetSchemaName()).add("NewTableName", newTableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableRestoreRequestId":
            return Optional.ofNullable(clazz.cast(tableRestoreRequestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "RequestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "ProgressInMegaBytes":
            return Optional.ofNullable(clazz.cast(progressInMegaBytes()));
        case "TotalDataInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalDataInMegaBytes()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SourceDatabaseName":
            return Optional.ofNullable(clazz.cast(sourceDatabaseName()));
        case "SourceSchemaName":
            return Optional.ofNullable(clazz.cast(sourceSchemaName()));
        case "SourceTableName":
            return Optional.ofNullable(clazz.cast(sourceTableName()));
        case "TargetDatabaseName":
            return Optional.ofNullable(clazz.cast(targetDatabaseName()));
        case "TargetSchemaName":
            return Optional.ofNullable(clazz.cast(targetSchemaName()));
        case "NewTableName":
            return Optional.ofNullable(clazz.cast(newTableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableRestoreStatus, T> g) {
        return obj -> g.apply((TableRestoreStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableRestoreStatus> {
        /**
         * <p>
         * The unique identifier for the table restore request.
         * </p>
         * 
         * @param tableRestoreRequestId
         *        The unique identifier for the table restore request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableRestoreRequestId(String tableRestoreRequestId);

        /**
         * <p>
         * A value that describes the current state of the table restore request.
         * </p>
         * <p>
         * Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>,
         * <code>IN_PROGRESS</code>
         * </p>
         * 
         * @param status
         *        A value that describes the current state of the table restore request.</p>
         *        <p>
         *        Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>
         * @see TableRestoreStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableRestoreStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * A value that describes the current state of the table restore request.
         * </p>
         * <p>
         * Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>,
         * <code>IN_PROGRESS</code>
         * </p>
         * 
         * @param status
         *        A value that describes the current state of the table restore request.</p>
         *        <p>
         *        Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>
         * @see TableRestoreStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableRestoreStatusType
         */
        Builder status(TableRestoreStatusType status);

        /**
         * <p>
         * A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>,
         * <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param message
         *        A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>
         *        , <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The time that the table restore request was made, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param requestTime
         *        The time that the table restore request was made, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * The amount of data restored to the new table so far, in megabytes (MB).
         * </p>
         * 
         * @param progressInMegaBytes
         *        The amount of data restored to the new table so far, in megabytes (MB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressInMegaBytes(Long progressInMegaBytes);

        /**
         * <p>
         * The total amount of data to restore to the new table, in megabytes (MB).
         * </p>
         * 
         * @param totalDataInMegaBytes
         *        The total amount of data to restore to the new table, in megabytes (MB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDataInMegaBytes(Long totalDataInMegaBytes);

        /**
         * <p>
         * The identifier of the Amazon Redshift cluster that the table is being restored to.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the Amazon Redshift cluster that the table is being restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The identifier of the snapshot that the table is being restored from.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier of the snapshot that the table is being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The name of the source database that contains the table being restored.
         * </p>
         * 
         * @param sourceDatabaseName
         *        The name of the source database that contains the table being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDatabaseName(String sourceDatabaseName);

        /**
         * <p>
         * The name of the source schema that contains the table being restored.
         * </p>
         * 
         * @param sourceSchemaName
         *        The name of the source schema that contains the table being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSchemaName(String sourceSchemaName);

        /**
         * <p>
         * The name of the source table being restored.
         * </p>
         * 
         * @param sourceTableName
         *        The name of the source table being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableName(String sourceTableName);

        /**
         * <p>
         * The name of the database to restore the table to.
         * </p>
         * 
         * @param targetDatabaseName
         *        The name of the database to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseName(String targetDatabaseName);

        /**
         * <p>
         * The name of the schema to restore the table to.
         * </p>
         * 
         * @param targetSchemaName
         *        The name of the schema to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSchemaName(String targetSchemaName);

        /**
         * <p>
         * The name of the table to create as a result of the table restore request.
         * </p>
         * 
         * @param newTableName
         *        The name of the table to create as a result of the table restore request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newTableName(String newTableName);
    }

    static final class BuilderImpl implements Builder {
        private String tableRestoreRequestId;

        private String status;

        private String message;

        private Instant requestTime;

        private Long progressInMegaBytes;

        private Long totalDataInMegaBytes;

        private String clusterIdentifier;

        private String snapshotIdentifier;

        private String sourceDatabaseName;

        private String sourceSchemaName;

        private String sourceTableName;

        private String targetDatabaseName;

        private String targetSchemaName;

        private String newTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(TableRestoreStatus model) {
            tableRestoreRequestId(model.tableRestoreRequestId);
            status(model.status);
            message(model.message);
            requestTime(model.requestTime);
            progressInMegaBytes(model.progressInMegaBytes);
            totalDataInMegaBytes(model.totalDataInMegaBytes);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            sourceDatabaseName(model.sourceDatabaseName);
            sourceSchemaName(model.sourceSchemaName);
            sourceTableName(model.sourceTableName);
            targetDatabaseName(model.targetDatabaseName);
            targetSchemaName(model.targetSchemaName);
            newTableName(model.newTableName);
        }

        public final String getTableRestoreRequestId() {
            return tableRestoreRequestId;
        }

        @Override
        public final Builder tableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
            return this;
        }

        public final void setTableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableRestoreStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        public final Long getProgressInMegaBytes() {
            return progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getTotalDataInMegaBytes() {
            return totalDataInMegaBytes;
        }

        @Override
        public final Builder totalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
            return this;
        }

        public final void setTotalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSourceDatabaseName() {
            return sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        public final String getSourceSchemaName() {
            return sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        public final String getSourceTableName() {
            return sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        public final String getTargetDatabaseName() {
            return targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        public final String getTargetSchemaName() {
            return targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        public final String getNewTableName() {
            return newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        @Override
        public TableRestoreStatus build() {
            return new TableRestoreStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
