/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResizeClusterRequest extends RedshiftRequest implements
        ToCopyableBuilder<ResizeClusterRequest.Builder, ResizeClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResizeClusterRequest::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResizeClusterRequest::clusterType)).setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterType").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResizeClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ResizeClusterRequest::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<Boolean> CLASSIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ResizeClusterRequest::classic)).setter(setter(Builder::classic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            CLUSTER_TYPE_FIELD, NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, CLASSIC_FIELD));

    private final String clusterIdentifier;

    private final String clusterType;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final Boolean classic;

    private ResizeClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.classic = builder.classic;
    }

    /**
     * <p>
     * The unique identifier for the cluster to resize.
     * </p>
     * 
     * @return The unique identifier for the cluster to resize.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The new cluster type for the specified cluster.
     * </p>
     * 
     * @return The new cluster type for the specified cluster.
     */
    public String clusterType() {
        return clusterType;
    }

    /**
     * <p>
     * The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.
     * </p>
     * 
     * @return The new node type for the nodes you are adding. If not specified, the cluster's current node type is
     *         used.
     */
    public String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The new number of nodes for the cluster.
     * </p>
     * 
     * @return The new number of nodes for the cluster.
     */
    public Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide
     * this parameter or set the value to <code>false</code>, the resize type is elastic.
     * </p>
     * 
     * @return A boolean value indicating whether the resize operation is using the classic resize process. If you don't
     *         provide this parameter or set the value to <code>false</code>, the resize type is elastic.
     */
    public Boolean classic() {
        return classic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(classic());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResizeClusterRequest)) {
            return false;
        }
        ResizeClusterRequest other = (ResizeClusterRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(clusterType(), other.clusterType()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(numberOfNodes(), other.numberOfNodes()) && Objects.equals(classic(), other.classic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResizeClusterRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("ClusterType", clusterType()).add("NodeType", nodeType()).add("NumberOfNodes", numberOfNodes())
                .add("Classic", classic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterType()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "Classic":
            return Optional.ofNullable(clazz.cast(classic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResizeClusterRequest, T> g) {
        return obj -> g.apply((ResizeClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResizeClusterRequest> {
        /**
         * <p>
         * The unique identifier for the cluster to resize.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier for the cluster to resize.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The new cluster type for the specified cluster.
         * </p>
         * 
         * @param clusterType
         *        The new cluster type for the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.
         * </p>
         * 
         * @param nodeType
         *        The new node type for the nodes you are adding. If not specified, the cluster's current node type is
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The new number of nodes for the cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The new number of nodes for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * A boolean value indicating whether the resize operation is using the classic resize process. If you don't
         * provide this parameter or set the value to <code>false</code>, the resize type is elastic.
         * </p>
         * 
         * @param classic
         *        A boolean value indicating whether the resize operation is using the classic resize process. If you
         *        don't provide this parameter or set the value to <code>false</code>, the resize type is elastic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classic(Boolean classic);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String clusterType;

        private String nodeType;

        private Integer numberOfNodes;

        private Boolean classic;

        private BuilderImpl() {
        }

        private BuilderImpl(ResizeClusterRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            clusterType(model.clusterType);
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            classic(model.classic);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getClusterType() {
            return clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getNodeType() {
            return nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Boolean getClassic() {
            return classic;
        }

        @Override
        public final Builder classic(Boolean classic) {
            this.classic = classic;
            return this;
        }

        public final void setClassic(Boolean classic) {
            this.classic = classic;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResizeClusterRequest build() {
            return new ResizeClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
