/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of elements to filter the returned node configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeConfigurationOptionsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeConfigurationOptionsFilter.Builder, NodeConfigurationOptionsFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NodeConfigurationOptionsFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NodeConfigurationOptionsFilter::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(NodeConfigurationOptionsFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("item").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OPERATOR_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String operator;

    private final List<String> values;

    private NodeConfigurationOptionsFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the element to filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link NodeConfigurationOptionsFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the element to filter.
     * @see NodeConfigurationOptionsFilterName
     */
    public NodeConfigurationOptionsFilterName name() {
        return NodeConfigurationOptionsFilterName.fromValue(name);
    }

    /**
     * <p>
     * The name of the element to filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link NodeConfigurationOptionsFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the element to filter.
     * @see NodeConfigurationOptionsFilterName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to
     * evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list of
     * values for 'in'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link OperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to
     *         evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a
     *         list of values for 'in'.
     * @see OperatorType
     */
    public OperatorType operator() {
        return OperatorType.fromValue(operator);
    }

    /**
     * <p>
     * The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to
     * evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list of
     * values for 'in'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link OperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to
     *         evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a
     *         list of values for 'in'.
     * @see OperatorType
     */
    public String operatorAsString() {
        return operator;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range
     * from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For
     * example, filter NumberOfNodes (name) GT (operator) 3 (values).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can
     *         range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to
     *         100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConfigurationOptionsFilter)) {
            return false;
        }
        NodeConfigurationOptionsFilter other = (NodeConfigurationOptionsFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(operatorAsString(), other.operatorAsString()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NodeConfigurationOptionsFilter").add("Name", nameAsString()).add("Operator", operatorAsString())
                .add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeConfigurationOptionsFilter, T> g) {
        return obj -> g.apply((NodeConfigurationOptionsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeConfigurationOptionsFilter> {
        /**
         * <p>
         * The name of the element to filter.
         * </p>
         * 
         * @param name
         *        The name of the element to filter.
         * @see NodeConfigurationOptionsFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeConfigurationOptionsFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the element to filter.
         * </p>
         * 
         * @param name
         *        The name of the element to filter.
         * @see NodeConfigurationOptionsFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeConfigurationOptionsFilterName
         */
        Builder name(NodeConfigurationOptionsFilterName name);

        /**
         * <p>
         * The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to
         * evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list
         * of values for 'in'.
         * </p>
         * 
         * @param operator
         *        The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value
         *        to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'.
         *        Provide a list of values for 'in'.
         * @see OperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatorType
         */
        Builder operator(String operator);

        /**
         * <p>
         * The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to
         * evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list
         * of values for 'in'.
         * </p>
         * 
         * @param operator
         *        The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value
         *        to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'.
         *        Provide a list of values for 'in'.
         * @see OperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatorType
         */
        Builder operator(OperatorType operator);

        /**
         * <p>
         * List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range
         * from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For
         * example, filter NumberOfNodes (name) GT (operator) 3 (values).
         * </p>
         * 
         * @param values
         *        List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values
         *        can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from
         *        0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range
         * from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For
         * example, filter NumberOfNodes (name) GT (operator) 3 (values).
         * </p>
         * 
         * @param values
         *        List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values
         *        can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from
         *        0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String operator;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeConfigurationOptionsFilter model) {
            name(model.name);
            operator(model.operator);
            values(model.values);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(NodeConfigurationOptionsFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOperator() {
            return operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(OperatorType operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValueStringListCopier.copy(values);
        }

        @Override
        public NodeConfigurationOptionsFilter build() {
            return new NodeConfigurationOptionsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
