/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTableRestoreStatusRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeTableRestoreStatusRequest.Builder, DescribeTableRestoreStatusRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTableRestoreStatusRequest::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> TABLE_RESTORE_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTableRestoreStatusRequest::tableRestoreRequestId))
            .setter(setter(Builder::tableRestoreRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableRestoreRequestId").build())
            .build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeTableRestoreStatusRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTableRestoreStatusRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            TABLE_RESTORE_REQUEST_ID_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String clusterIdentifier;

    private final String tableRestoreRequestId;

    private final Integer maxRecords;

    private final String marker;

    private DescribeTableRestoreStatusRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.tableRestoreRequestId = builder.tableRestoreRequestId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon Redshift cluster that the table is being restored to.
     * </p>
     * 
     * @return The Amazon Redshift cluster that the table is being restored to.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the table restore request to return status for. If you don't specify a
     * <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status of all
     * in-progress table restore requests.
     * </p>
     * 
     * @return The identifier of the table restore request to return status for. If you don't specify a
     *         <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status
     *         of all in-progress table restore requests.
     */
    public String tableRestoreRequestId() {
        return tableRestoreRequestId;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
     * remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
     *         remaining results can be retrieved.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by the
     * <code>MaxRecords</code> parameter.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If
     *         this parameter is specified, the response includes only records beyond the marker, up to the value
     *         specified by the <code>MaxRecords</code> parameter.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tableRestoreRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableRestoreStatusRequest)) {
            return false;
        }
        DescribeTableRestoreStatusRequest other = (DescribeTableRestoreStatusRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(tableRestoreRequestId(), other.tableRestoreRequestId())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTableRestoreStatusRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("TableRestoreRequestId", tableRestoreRequestId()).add("MaxRecords", maxRecords()).add("Marker", marker())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "TableRestoreRequestId":
            return Optional.ofNullable(clazz.cast(tableRestoreRequestId()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableRestoreStatusRequest, T> g) {
        return obj -> g.apply((DescribeTableRestoreStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTableRestoreStatusRequest> {
        /**
         * <p>
         * The Amazon Redshift cluster that the table is being restored to.
         * </p>
         * 
         * @param clusterIdentifier
         *        The Amazon Redshift cluster that the table is being restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The identifier of the table restore request to return status for. If you don't specify a
         * <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status of
         * all in-progress table restore requests.
         * </p>
         * 
         * @param tableRestoreRequestId
         *        The identifier of the table restore request to return status for. If you don't specify a
         *        <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the
         *        status of all in-progress table restore requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableRestoreRequestId(String tableRestoreRequestId);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the
         * remaining results can be retrieved.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that
         *        the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * the <code>MaxRecords</code> parameter.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request.
         *        If this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by the <code>MaxRecords</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String tableRestoreRequestId;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableRestoreStatusRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            tableRestoreRequestId(model.tableRestoreRequestId);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getTableRestoreRequestId() {
            return tableRestoreRequestId;
        }

        @Override
        public final Builder tableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
            return this;
        }

        public final void setTableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTableRestoreStatusRequest build() {
            return new DescribeTableRestoreStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
