/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchModifyClusterSnapshotsRequest extends RedshiftRequest implements
        ToCopyableBuilder<BatchModifyClusterSnapshotsRequest.Builder, BatchModifyClusterSnapshotsRequest> {
    private static final SdkField<List<String>> SNAPSHOT_IDENTIFIER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchModifyClusterSnapshotsRequest::snapshotIdentifierList))
            .setter(setter(Builder::snapshotIdentifierList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifierList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("String")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("String").build()).build()).build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchModifyClusterSnapshotsRequest::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(BatchModifyClusterSnapshotsRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SNAPSHOT_IDENTIFIER_LIST_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, FORCE_FIELD));

    private final List<String> snapshotIdentifierList;

    private final Integer manualSnapshotRetentionPeriod;

    private final Boolean force;

    private BatchModifyClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifierList = builder.snapshotIdentifierList;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.force = builder.force;
    }

    /**
     * Returns true if the SnapshotIdentifierList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSnapshotIdentifierList() {
        return snapshotIdentifierList != null && !(snapshotIdentifierList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of snapshot identifiers you want to modify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSnapshotIdentifierList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of snapshot identifiers you want to modify.
     */
    public List<String> snapshotIdentifierList() {
        return snapshotIdentifierList;
    }

    /**
     * <p>
     * The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is
     * retained indefinitely.
     * </p>
     * <p>
     * The number must be either -1 or an integer between 1 and 3,653.
     * </p>
     * <p>
     * If you decrease the manual snapshot retention period from its current value, existing manual snapshots that fall
     * outside of the new retention period will return an error. If you want to suppress the errors and delete the
     * snapshots, use the force option.
     * </p>
     * 
     * @return The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot
     *         is retained indefinitely.</p>
     *         <p>
     *         The number must be either -1 or an integer between 1 and 3,653.
     *         </p>
     *         <p>
     *         If you decrease the manual snapshot retention period from its current value, existing manual snapshots
     *         that fall outside of the new retention period will return an error. If you want to suppress the errors
     *         and delete the snapshots, use the force option.
     */
    public Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * A boolean value indicating whether to override an exception if the retention period has passed.
     * </p>
     * 
     * @return A boolean value indicating whether to override an exception if the retention period has passed.
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifierList());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchModifyClusterSnapshotsRequest)) {
            return false;
        }
        BatchModifyClusterSnapshotsRequest other = (BatchModifyClusterSnapshotsRequest) obj;
        return Objects.equals(snapshotIdentifierList(), other.snapshotIdentifierList())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchModifyClusterSnapshotsRequest").add("SnapshotIdentifierList", snapshotIdentifierList())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIdentifierList":
            return Optional.ofNullable(clazz.cast(snapshotIdentifierList()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchModifyClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((BatchModifyClusterSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchModifyClusterSnapshotsRequest> {
        /**
         * <p>
         * A list of snapshot identifiers you want to modify.
         * </p>
         * 
         * @param snapshotIdentifierList
         *        A list of snapshot identifiers you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifierList(Collection<String> snapshotIdentifierList);

        /**
         * <p>
         * A list of snapshot identifiers you want to modify.
         * </p>
         * 
         * @param snapshotIdentifierList
         *        A list of snapshot identifiers you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifierList(String... snapshotIdentifierList);

        /**
         * <p>
         * The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is
         * retained indefinitely.
         * </p>
         * <p>
         * The number must be either -1 or an integer between 1 and 3,653.
         * </p>
         * <p>
         * If you decrease the manual snapshot retention period from its current value, existing manual snapshots that
         * fall outside of the new retention period will return an error. If you want to suppress the errors and delete
         * the snapshots, use the force option.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The number of days that a manual snapshot is retained. If you specify the value -1, the manual
         *        snapshot is retained indefinitely.</p>
         *        <p>
         *        The number must be either -1 or an integer between 1 and 3,653.
         *        </p>
         *        <p>
         *        If you decrease the manual snapshot retention period from its current value, existing manual snapshots
         *        that fall outside of the new retention period will return an error. If you want to suppress the errors
         *        and delete the snapshots, use the force option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * A boolean value indicating whether to override an exception if the retention period has passed.
         * </p>
         * 
         * @param force
         *        A boolean value indicating whether to override an exception if the retention period has passed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private List<String> snapshotIdentifierList = DefaultSdkAutoConstructList.getInstance();

        private Integer manualSnapshotRetentionPeriod;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchModifyClusterSnapshotsRequest model) {
            super(model);
            snapshotIdentifierList(model.snapshotIdentifierList);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            force(model.force);
        }

        public final Collection<String> getSnapshotIdentifierList() {
            return snapshotIdentifierList;
        }

        @Override
        public final Builder snapshotIdentifierList(Collection<String> snapshotIdentifierList) {
            this.snapshotIdentifierList = SnapshotIdentifierListCopier.copy(snapshotIdentifierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIdentifierList(String... snapshotIdentifierList) {
            snapshotIdentifierList(Arrays.asList(snapshotIdentifierList));
            return this;
        }

        public final void setSnapshotIdentifierList(Collection<String> snapshotIdentifierList) {
            this.snapshotIdentifierList = SnapshotIdentifierListCopier.copy(snapshotIdentifierList);
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchModifyClusterSnapshotsRequest build() {
            return new BatchModifyClusterSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
