/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeSnapshotAccessRequest extends RedshiftRequest implements
        ToCopyableBuilder<RevokeSnapshotAccessRequest.Builder, RevokeSnapshotAccessRequest> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RevokeSnapshotAccessRequest::snapshotIdentifier)).setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RevokeSnapshotAccessRequest::snapshotClusterIdentifier))
            .setter(setter(Builder::snapshotClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build())
            .build();

    private static final SdkField<String> ACCOUNT_WITH_RESTORE_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RevokeSnapshotAccessRequest::accountWithRestoreAccess))
            .setter(setter(Builder::accountWithRestoreAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountWithRestoreAccess").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD,
            SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, ACCOUNT_WITH_RESTORE_ACCESS_FIELD));

    private final String snapshotIdentifier;

    private final String snapshotClusterIdentifier;

    private final String accountWithRestoreAccess;

    private RevokeSnapshotAccessRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.accountWithRestoreAccess = builder.accountWithRestoreAccess;
    }

    /**
     * <p>
     * The identifier of the snapshot that the account can no longer access.
     * </p>
     * 
     * @return The identifier of the snapshot that the account can no longer access.
     */
    public String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a
     * policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     * </p>
     * 
     * @return The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user
     *         has a policy containing a snapshot resource element that specifies anything other than * for the cluster
     *         name.
     */
    public String snapshotClusterIdentifier() {
        return snapshotClusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the AWS customer account that can no longer restore the specified snapshot.
     * </p>
     * 
     * @return The identifier of the AWS customer account that can no longer restore the specified snapshot.
     */
    public String accountWithRestoreAccess() {
        return accountWithRestoreAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(accountWithRestoreAccess());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSnapshotAccessRequest)) {
            return false;
        }
        RevokeSnapshotAccessRequest other = (RevokeSnapshotAccessRequest) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotClusterIdentifier(), other.snapshotClusterIdentifier())
                && Objects.equals(accountWithRestoreAccess(), other.accountWithRestoreAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RevokeSnapshotAccessRequest").add("SnapshotIdentifier", snapshotIdentifier())
                .add("SnapshotClusterIdentifier", snapshotClusterIdentifier())
                .add("AccountWithRestoreAccess", accountWithRestoreAccess()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotClusterIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotClusterIdentifier()));
        case "AccountWithRestoreAccess":
            return Optional.ofNullable(clazz.cast(accountWithRestoreAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeSnapshotAccessRequest, T> g) {
        return obj -> g.apply((RevokeSnapshotAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, RevokeSnapshotAccessRequest> {
        /**
         * <p>
         * The identifier of the snapshot that the account can no longer access.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier of the snapshot that the account can no longer access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has
         * a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
         * </p>
         * 
         * @param snapshotClusterIdentifier
         *        The identifier of the cluster the snapshot was created from. This parameter is required if your IAM
         *        user has a policy containing a snapshot resource element that specifies anything other than * for the
         *        cluster name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotClusterIdentifier(String snapshotClusterIdentifier);

        /**
         * <p>
         * The identifier of the AWS customer account that can no longer restore the specified snapshot.
         * </p>
         * 
         * @param accountWithRestoreAccess
         *        The identifier of the AWS customer account that can no longer restore the specified snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountWithRestoreAccess(String accountWithRestoreAccess);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private String snapshotClusterIdentifier;

        private String accountWithRestoreAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSnapshotAccessRequest model) {
            super(model);
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            accountWithRestoreAccess(model.accountWithRestoreAccess);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        public final String getAccountWithRestoreAccess() {
            return accountWithRestoreAccess;
        }

        @Override
        public final Builder accountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
            return this;
        }

        public final void setAccountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeSnapshotAccessRequest build() {
            return new RevokeSnapshotAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
