/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a <code>RevisionTarget</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevisionTarget implements SdkPojo, Serializable, ToCopyableBuilder<RevisionTarget.Builder, RevisionTarget> {
    private static final SdkField<String> DATABASE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RevisionTarget::databaseRevision)).setter(setter(Builder::databaseRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseRevision").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RevisionTarget::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> DATABASE_REVISION_RELEASE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RevisionTarget::databaseRevisionReleaseDate))
            .setter(setter(Builder::databaseRevisionReleaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseRevisionReleaseDate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_REVISION_FIELD,
            DESCRIPTION_FIELD, DATABASE_REVISION_RELEASE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseRevision;

    private final String description;

    private final Instant databaseRevisionReleaseDate;

    private RevisionTarget(BuilderImpl builder) {
        this.databaseRevision = builder.databaseRevision;
        this.description = builder.description;
        this.databaseRevisionReleaseDate = builder.databaseRevisionReleaseDate;
    }

    /**
     * <p>
     * A unique string that identifies the version to update the cluster to. You can use this value in
     * <a>ModifyClusterDbRevision</a>.
     * </p>
     * 
     * @return A unique string that identifies the version to update the cluster to. You can use this value in
     *         <a>ModifyClusterDbRevision</a>.
     */
    public String databaseRevision() {
        return databaseRevision;
    }

    /**
     * <p>
     * A string that describes the changes and features that will be applied to the cluster when it is updated to the
     * corresponding <a>ClusterDbRevision</a>.
     * </p>
     * 
     * @return A string that describes the changes and features that will be applied to the cluster when it is updated
     *         to the corresponding <a>ClusterDbRevision</a>.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date on which the database revision was released.
     * </p>
     * 
     * @return The date on which the database revision was released.
     */
    public Instant databaseRevisionReleaseDate() {
        return databaseRevisionReleaseDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseRevision());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(databaseRevisionReleaseDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionTarget)) {
            return false;
        }
        RevisionTarget other = (RevisionTarget) obj;
        return Objects.equals(databaseRevision(), other.databaseRevision()) && Objects.equals(description(), other.description())
                && Objects.equals(databaseRevisionReleaseDate(), other.databaseRevisionReleaseDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RevisionTarget").add("DatabaseRevision", databaseRevision()).add("Description", description())
                .add("DatabaseRevisionReleaseDate", databaseRevisionReleaseDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseRevision":
            return Optional.ofNullable(clazz.cast(databaseRevision()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DatabaseRevisionReleaseDate":
            return Optional.ofNullable(clazz.cast(databaseRevisionReleaseDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevisionTarget, T> g) {
        return obj -> g.apply((RevisionTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevisionTarget> {
        /**
         * <p>
         * A unique string that identifies the version to update the cluster to. You can use this value in
         * <a>ModifyClusterDbRevision</a>.
         * </p>
         * 
         * @param databaseRevision
         *        A unique string that identifies the version to update the cluster to. You can use this value in
         *        <a>ModifyClusterDbRevision</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseRevision(String databaseRevision);

        /**
         * <p>
         * A string that describes the changes and features that will be applied to the cluster when it is updated to
         * the corresponding <a>ClusterDbRevision</a>.
         * </p>
         * 
         * @param description
         *        A string that describes the changes and features that will be applied to the cluster when it is
         *        updated to the corresponding <a>ClusterDbRevision</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date on which the database revision was released.
         * </p>
         * 
         * @param databaseRevisionReleaseDate
         *        The date on which the database revision was released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseRevisionReleaseDate(Instant databaseRevisionReleaseDate);
    }

    static final class BuilderImpl implements Builder {
        private String databaseRevision;

        private String description;

        private Instant databaseRevisionReleaseDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionTarget model) {
            databaseRevision(model.databaseRevision);
            description(model.description);
            databaseRevisionReleaseDate(model.databaseRevisionReleaseDate);
        }

        public final String getDatabaseRevision() {
            return databaseRevision;
        }

        @Override
        public final Builder databaseRevision(String databaseRevision) {
            this.databaseRevision = databaseRevision;
            return this;
        }

        public final void setDatabaseRevision(String databaseRevision) {
            this.databaseRevision = databaseRevision;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getDatabaseRevisionReleaseDate() {
            return databaseRevisionReleaseDate;
        }

        @Override
        public final Builder databaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
            return this;
        }

        public final void setDatabaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
        }

        @Override
        public RevisionTarget build() {
            return new RevisionTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
