/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes event subscriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<EventSubscription.Builder, EventSubscription> {
    private static final SdkField<String> CUSTOMER_AWS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventSubscription::customerAwsId)).setter(setter(Builder::customerAwsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAwsId").build()).build();

    private static final SdkField<String> CUST_SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventSubscription::custSubscriptionId)).setter(setter(Builder::custSubscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustSubscriptionId").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventSubscription::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventSubscription::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> SUBSCRIPTION_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(EventSubscription::subscriptionCreationTime)).setter(setter(Builder::subscriptionCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionCreationTime").build())
            .build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventSubscription::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<String>> SOURCE_IDS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventSubscription::sourceIdsList))
            .setter(setter(Builder::sourceIdsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SourceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SourceId").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventSubscription::eventCategoriesList))
            .setter(setter(Builder::eventCategoriesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoriesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategory")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategory").build()).build()).build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventSubscription::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EventSubscription::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(EventSubscription::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_AWS_ID_FIELD,
            CUST_SUBSCRIPTION_ID_FIELD, SNS_TOPIC_ARN_FIELD, STATUS_FIELD, SUBSCRIPTION_CREATION_TIME_FIELD, SOURCE_TYPE_FIELD,
            SOURCE_IDS_LIST_FIELD, EVENT_CATEGORIES_LIST_FIELD, SEVERITY_FIELD, ENABLED_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customerAwsId;

    private final String custSubscriptionId;

    private final String snsTopicArn;

    private final String status;

    private final Instant subscriptionCreationTime;

    private final String sourceType;

    private final List<String> sourceIdsList;

    private final List<String> eventCategoriesList;

    private final String severity;

    private final Boolean enabled;

    private final List<Tag> tags;

    private EventSubscription(BuilderImpl builder) {
        this.customerAwsId = builder.customerAwsId;
        this.custSubscriptionId = builder.custSubscriptionId;
        this.snsTopicArn = builder.snsTopicArn;
        this.status = builder.status;
        this.subscriptionCreationTime = builder.subscriptionCreationTime;
        this.sourceType = builder.sourceType;
        this.sourceIdsList = builder.sourceIdsList;
        this.eventCategoriesList = builder.eventCategoriesList;
        this.severity = builder.severity;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The AWS customer account associated with the Amazon Redshift event notification subscription.
     * </p>
     * 
     * @return The AWS customer account associated with the Amazon Redshift event notification subscription.
     */
    public String customerAwsId() {
        return customerAwsId;
    }

    /**
     * <p>
     * The name of the Amazon Redshift event notification subscription.
     * </p>
     * 
     * @return The name of the Amazon Redshift event notification subscription.
     */
    public String custSubscriptionId() {
        return custSubscriptionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The status of the Amazon Redshift event notification subscription.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can be one of the following: active | no-permission | topic-not-exist
     * </p>
     * </li>
     * <li>
     * <p>
     * The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS
     * topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the Amazon Redshift event notification subscription.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can be one of the following: active | no-permission | topic-not-exist
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon
     *         SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was
     *         created.
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the Amazon Redshift event notification subscription was created.
     * </p>
     * 
     * @return The date and time the Amazon Redshift event notification subscription was created.
     */
    public Instant subscriptionCreationTime() {
        return subscriptionCreationTime;
    }

    /**
     * <p>
     * The source type of the events returned by the Amazon Redshift event notification, such as cluster,
     * cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
     * </p>
     * 
     * @return The source type of the events returned by the Amazon Redshift event notification, such as cluster,
     *         cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
     */
    public String sourceType() {
        return sourceType;
    }

    /**
     * Returns true if the SourceIdsList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSourceIdsList() {
        return sourceIdsList != null && !(sourceIdsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the sources that publish events to the Amazon Redshift event notification subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceIdsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the sources that publish events to the Amazon Redshift event notification subscription.
     */
    public List<String> sourceIdsList() {
        return sourceIdsList;
    }

    /**
     * Returns true if the EventCategoriesList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventCategoriesList() {
        return eventCategoriesList != null && !(eventCategoriesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Redshift event categories specified in the event notification subscription.
     * </p>
     * <p>
     * Values: Configuration, Management, Monitoring, Security
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventCategoriesList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of Amazon Redshift event categories specified in the event notification subscription.</p>
     *         <p>
     *         Values: Configuration, Management, Monitoring, Security
     */
    public List<String> eventCategoriesList() {
        return eventCategoriesList;
    }

    /**
     * <p>
     * The event severity specified in the Amazon Redshift event notification subscription.
     * </p>
     * <p>
     * Values: ERROR, INFO
     * </p>
     * 
     * @return The event severity specified in the Amazon Redshift event notification subscription.</p>
     *         <p>
     *         Values: ERROR, INFO
     */
    public String severity() {
        return severity;
    }

    /**
     * <p>
     * A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the subscription
     * is enabled.
     * </p>
     * 
     * @return A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the
     *         subscription is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags for the event subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of tags for the event subscription.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerAwsId());
        hashCode = 31 * hashCode + Objects.hashCode(custSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIdsList());
        hashCode = 31 * hashCode + Objects.hashCode(eventCategoriesList());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription) obj;
        return Objects.equals(customerAwsId(), other.customerAwsId())
                && Objects.equals(custSubscriptionId(), other.custSubscriptionId())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(status(), other.status())
                && Objects.equals(subscriptionCreationTime(), other.subscriptionCreationTime())
                && Objects.equals(sourceType(), other.sourceType()) && Objects.equals(sourceIdsList(), other.sourceIdsList())
                && Objects.equals(eventCategoriesList(), other.eventCategoriesList())
                && Objects.equals(severity(), other.severity()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventSubscription").add("CustomerAwsId", customerAwsId())
                .add("CustSubscriptionId", custSubscriptionId()).add("SnsTopicArn", snsTopicArn()).add("Status", status())
                .add("SubscriptionCreationTime", subscriptionCreationTime()).add("SourceType", sourceType())
                .add("SourceIdsList", sourceIdsList()).add("EventCategoriesList", eventCategoriesList())
                .add("Severity", severity()).add("Enabled", enabled()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerAwsId":
            return Optional.ofNullable(clazz.cast(customerAwsId()));
        case "CustSubscriptionId":
            return Optional.ofNullable(clazz.cast(custSubscriptionId()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SubscriptionCreationTime":
            return Optional.ofNullable(clazz.cast(subscriptionCreationTime()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "SourceIdsList":
            return Optional.ofNullable(clazz.cast(sourceIdsList()));
        case "EventCategoriesList":
            return Optional.ofNullable(clazz.cast(eventCategoriesList()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSubscription, T> g) {
        return obj -> g.apply((EventSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSubscription> {
        /**
         * <p>
         * The AWS customer account associated with the Amazon Redshift event notification subscription.
         * </p>
         * 
         * @param customerAwsId
         *        The AWS customer account associated with the Amazon Redshift event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAwsId(String customerAwsId);

        /**
         * <p>
         * The name of the Amazon Redshift event notification subscription.
         * </p>
         * 
         * @param custSubscriptionId
         *        The name of the Amazon Redshift event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custSubscriptionId(String custSubscriptionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The status of the Amazon Redshift event notification subscription.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can be one of the following: active | no-permission | topic-not-exist
         * </p>
         * </li>
         * <li>
         * <p>
         * The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS
         * topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Amazon Redshift event notification subscription.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can be one of the following: active | no-permission | topic-not-exist
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the
         *        Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
         *        subscription was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the Amazon Redshift event notification subscription was created.
         * </p>
         * 
         * @param subscriptionCreationTime
         *        The date and time the Amazon Redshift event notification subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionCreationTime(Instant subscriptionCreationTime);

        /**
         * <p>
         * The source type of the events returned by the Amazon Redshift event notification, such as cluster,
         * cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
         * </p>
         * 
         * @param sourceType
         *        The source type of the events returned by the Amazon Redshift event notification, such as cluster,
         *        cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * A list of the sources that publish events to the Amazon Redshift event notification subscription.
         * </p>
         * 
         * @param sourceIdsList
         *        A list of the sources that publish events to the Amazon Redshift event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdsList(Collection<String> sourceIdsList);

        /**
         * <p>
         * A list of the sources that publish events to the Amazon Redshift event notification subscription.
         * </p>
         * 
         * @param sourceIdsList
         *        A list of the sources that publish events to the Amazon Redshift event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdsList(String... sourceIdsList);

        /**
         * <p>
         * The list of Amazon Redshift event categories specified in the event notification subscription.
         * </p>
         * <p>
         * Values: Configuration, Management, Monitoring, Security
         * </p>
         * 
         * @param eventCategoriesList
         *        The list of Amazon Redshift event categories specified in the event notification subscription.</p>
         *        <p>
         *        Values: Configuration, Management, Monitoring, Security
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesList(Collection<String> eventCategoriesList);

        /**
         * <p>
         * The list of Amazon Redshift event categories specified in the event notification subscription.
         * </p>
         * <p>
         * Values: Configuration, Management, Monitoring, Security
         * </p>
         * 
         * @param eventCategoriesList
         *        The list of Amazon Redshift event categories specified in the event notification subscription.</p>
         *        <p>
         *        Values: Configuration, Management, Monitoring, Security
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesList(String... eventCategoriesList);

        /**
         * <p>
         * The event severity specified in the Amazon Redshift event notification subscription.
         * </p>
         * <p>
         * Values: ERROR, INFO
         * </p>
         * 
         * @param severity
         *        The event severity specified in the Amazon Redshift event notification subscription.</p>
         *        <p>
         *        Values: ERROR, INFO
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);

        /**
         * <p>
         * A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the
         * subscription is enabled.
         * </p>
         * 
         * @param enabled
         *        A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the
         *        subscription is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The list of tags for the event subscription.
         * </p>
         * 
         * @param tags
         *        The list of tags for the event subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the event subscription.
         * </p>
         * 
         * @param tags
         *        The list of tags for the event subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the event subscription.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String customerAwsId;

        private String custSubscriptionId;

        private String snsTopicArn;

        private String status;

        private Instant subscriptionCreationTime;

        private String sourceType;

        private List<String> sourceIdsList = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventCategoriesList = DefaultSdkAutoConstructList.getInstance();

        private String severity;

        private Boolean enabled;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            customerAwsId(model.customerAwsId);
            custSubscriptionId(model.custSubscriptionId);
            snsTopicArn(model.snsTopicArn);
            status(model.status);
            subscriptionCreationTime(model.subscriptionCreationTime);
            sourceType(model.sourceType);
            sourceIdsList(model.sourceIdsList);
            eventCategoriesList(model.eventCategoriesList);
            severity(model.severity);
            enabled(model.enabled);
            tags(model.tags);
        }

        public final String getCustomerAwsId() {
            return customerAwsId;
        }

        @Override
        public final Builder customerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
            return this;
        }

        public final void setCustomerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
        }

        public final String getCustSubscriptionId() {
            return custSubscriptionId;
        }

        @Override
        public final Builder custSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
            return this;
        }

        public final void setCustSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getSubscriptionCreationTime() {
            return subscriptionCreationTime;
        }

        @Override
        public final Builder subscriptionCreationTime(Instant subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
            return this;
        }

        public final void setSubscriptionCreationTime(Instant subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getSourceIdsList() {
            return sourceIdsList;
        }

        @Override
        public final Builder sourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIdsList(String... sourceIdsList) {
            sourceIdsList(Arrays.asList(sourceIdsList));
            return this;
        }

        public final void setSourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
        }

        public final Collection<String> getEventCategoriesList() {
            return eventCategoriesList;
        }

        @Override
        public final Builder eventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesList(String... eventCategoriesList) {
            eventCategoriesList(Arrays.asList(eventCategoriesList));
            return this;
        }

        public final void setEventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public EventSubscription build() {
            return new EventSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
