/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes event information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventInfoMap implements SdkPojo, Serializable, ToCopyableBuilder<EventInfoMap.Builder, EventInfoMap> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventInfoMap::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventInfoMap::eventCategories))
            .setter(setter(Builder::eventCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategory")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategory").build()).build()).build()).build();

    private static final SdkField<String> EVENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventInfoMap::eventDescription)).setter(setter(Builder::eventDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDescription").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventInfoMap::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_CATEGORIES_FIELD, EVENT_DESCRIPTION_FIELD, SEVERITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final List<String> eventCategories;

    private final String eventDescription;

    private final String severity;

    private EventInfoMap(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventCategories = builder.eventCategories;
        this.eventDescription = builder.eventDescription;
        this.severity = builder.severity;
    }

    /**
     * <p>
     * The identifier of an Amazon Redshift event.
     * </p>
     * 
     * @return The identifier of an Amazon Redshift event.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * Returns true if the EventCategories property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventCategories() {
        return eventCategories != null && !(eventCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The category of an Amazon Redshift event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The category of an Amazon Redshift event.
     */
    public List<String> eventCategories() {
        return eventCategories;
    }

    /**
     * <p>
     * The description of an Amazon Redshift event.
     * </p>
     * 
     * @return The description of an Amazon Redshift event.
     */
    public String eventDescription() {
        return eventDescription;
    }

    /**
     * <p>
     * The severity of the event.
     * </p>
     * <p>
     * Values: ERROR, INFO
     * </p>
     * 
     * @return The severity of the event.</p>
     *         <p>
     *         Values: ERROR, INFO
     */
    public String severity() {
        return severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(eventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInfoMap)) {
            return false;
        }
        EventInfoMap other = (EventInfoMap) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventCategories(), other.eventCategories())
                && Objects.equals(eventDescription(), other.eventDescription()) && Objects.equals(severity(), other.severity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventInfoMap").add("EventId", eventId()).add("EventCategories", eventCategories())
                .add("EventDescription", eventDescription()).add("Severity", severity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "EventCategories":
            return Optional.ofNullable(clazz.cast(eventCategories()));
        case "EventDescription":
            return Optional.ofNullable(clazz.cast(eventDescription()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventInfoMap, T> g) {
        return obj -> g.apply((EventInfoMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventInfoMap> {
        /**
         * <p>
         * The identifier of an Amazon Redshift event.
         * </p>
         * 
         * @param eventId
         *        The identifier of an Amazon Redshift event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The category of an Amazon Redshift event.
         * </p>
         * 
         * @param eventCategories
         *        The category of an Amazon Redshift event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(Collection<String> eventCategories);

        /**
         * <p>
         * The category of an Amazon Redshift event.
         * </p>
         * 
         * @param eventCategories
         *        The category of an Amazon Redshift event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(String... eventCategories);

        /**
         * <p>
         * The description of an Amazon Redshift event.
         * </p>
         * 
         * @param eventDescription
         *        The description of an Amazon Redshift event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDescription(String eventDescription);

        /**
         * <p>
         * The severity of the event.
         * </p>
         * <p>
         * Values: ERROR, INFO
         * </p>
         * 
         * @param severity
         *        The severity of the event.</p>
         *        <p>
         *        Values: ERROR, INFO
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private String eventDescription;

        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventInfoMap model) {
            eventId(model.eventId);
            eventCategories(model.eventCategories);
            eventDescription(model.eventDescription);
            severity(model.severity);
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final Collection<String> getEventCategories() {
            return eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String... eventCategories) {
            eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final String getEventDescription() {
            return eventDescription;
        }

        @Override
        public final Builder eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public EventInfoMap build() {
            return new EventInfoMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
