/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of logging for a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableLoggingResponse extends RedshiftResponse implements
        ToCopyableBuilder<EnableLoggingResponse.Builder, EnableLoggingResponse> {
    private static final SdkField<Boolean> LOGGING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EnableLoggingResponse::loggingEnabled)).setter(setter(Builder::loggingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingEnabled").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableLoggingResponse::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableLoggingResponse::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_DELIVERY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(EnableLoggingResponse::lastSuccessfulDeliveryTime))
            .setter(setter(Builder::lastSuccessfulDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulDeliveryTime").build())
            .build();

    private static final SdkField<Instant> LAST_FAILURE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(EnableLoggingResponse::lastFailureTime)).setter(setter(Builder::lastFailureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureTime").build()).build();

    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableLoggingResponse::lastFailureMessage)).setter(setter(Builder::lastFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_ENABLED_FIELD,
            BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, LAST_SUCCESSFUL_DELIVERY_TIME_FIELD, LAST_FAILURE_TIME_FIELD,
            LAST_FAILURE_MESSAGE_FIELD));

    private final Boolean loggingEnabled;

    private final String bucketName;

    private final String s3KeyPrefix;

    private final Instant lastSuccessfulDeliveryTime;

    private final Instant lastFailureTime;

    private final String lastFailureMessage;

    private EnableLoggingResponse(BuilderImpl builder) {
        super(builder);
        this.loggingEnabled = builder.loggingEnabled;
        this.bucketName = builder.bucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.lastSuccessfulDeliveryTime = builder.lastSuccessfulDeliveryTime;
        this.lastFailureTime = builder.lastFailureTime;
        this.lastFailureMessage = builder.lastFailureMessage;
    }

    /**
     * <p>
     * <code>true</code> if logging is on, <code>false</code> if logging is off.
     * </p>
     * 
     * @return <code>true</code> if logging is on, <code>false</code> if logging is off.
     */
    public Boolean loggingEnabled() {
        return loggingEnabled;
    }

    /**
     * <p>
     * The name of the S3 bucket where the log files are stored.
     * </p>
     * 
     * @return The name of the S3 bucket where the log files are stored.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The prefix applied to the log file names.
     * </p>
     * 
     * @return The prefix applied to the log file names.
     */
    public String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * The last time that logs were delivered.
     * </p>
     * 
     * @return The last time that logs were delivered.
     */
    public Instant lastSuccessfulDeliveryTime() {
        return lastSuccessfulDeliveryTime;
    }

    /**
     * <p>
     * The last time when logs failed to be delivered.
     * </p>
     * 
     * @return The last time when logs failed to be delivered.
     */
    public Instant lastFailureTime() {
        return lastFailureTime;
    }

    /**
     * <p>
     * The message indicating that logs failed to be delivered.
     * </p>
     * 
     * @return The message indicating that logs failed to be delivered.
     */
    public String lastFailureMessage() {
        return lastFailureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableLoggingResponse)) {
            return false;
        }
        EnableLoggingResponse other = (EnableLoggingResponse) obj;
        return Objects.equals(loggingEnabled(), other.loggingEnabled()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix())
                && Objects.equals(lastSuccessfulDeliveryTime(), other.lastSuccessfulDeliveryTime())
                && Objects.equals(lastFailureTime(), other.lastFailureTime())
                && Objects.equals(lastFailureMessage(), other.lastFailureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnableLoggingResponse").add("LoggingEnabled", loggingEnabled()).add("BucketName", bucketName())
                .add("S3KeyPrefix", s3KeyPrefix()).add("LastSuccessfulDeliveryTime", lastSuccessfulDeliveryTime())
                .add("LastFailureTime", lastFailureTime()).add("LastFailureMessage", lastFailureMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoggingEnabled":
            return Optional.ofNullable(clazz.cast(loggingEnabled()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "LastSuccessfulDeliveryTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulDeliveryTime()));
        case "LastFailureTime":
            return Optional.ofNullable(clazz.cast(lastFailureTime()));
        case "LastFailureMessage":
            return Optional.ofNullable(clazz.cast(lastFailureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableLoggingResponse, T> g) {
        return obj -> g.apply((EnableLoggingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, EnableLoggingResponse> {
        /**
         * <p>
         * <code>true</code> if logging is on, <code>false</code> if logging is off.
         * </p>
         * 
         * @param loggingEnabled
         *        <code>true</code> if logging is on, <code>false</code> if logging is off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingEnabled(Boolean loggingEnabled);

        /**
         * <p>
         * The name of the S3 bucket where the log files are stored.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket where the log files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The prefix applied to the log file names.
         * </p>
         * 
         * @param s3KeyPrefix
         *        The prefix applied to the log file names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * The last time that logs were delivered.
         * </p>
         * 
         * @param lastSuccessfulDeliveryTime
         *        The last time that logs were delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulDeliveryTime(Instant lastSuccessfulDeliveryTime);

        /**
         * <p>
         * The last time when logs failed to be delivered.
         * </p>
         * 
         * @param lastFailureTime
         *        The last time when logs failed to be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureTime(Instant lastFailureTime);

        /**
         * <p>
         * The message indicating that logs failed to be delivered.
         * </p>
         * 
         * @param lastFailureMessage
         *        The message indicating that logs failed to be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureMessage(String lastFailureMessage);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private Boolean loggingEnabled;

        private String bucketName;

        private String s3KeyPrefix;

        private Instant lastSuccessfulDeliveryTime;

        private Instant lastFailureTime;

        private String lastFailureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableLoggingResponse model) {
            super(model);
            loggingEnabled(model.loggingEnabled);
            bucketName(model.bucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            lastSuccessfulDeliveryTime(model.lastSuccessfulDeliveryTime);
            lastFailureTime(model.lastFailureTime);
            lastFailureMessage(model.lastFailureMessage);
        }

        public final Boolean getLoggingEnabled() {
            return loggingEnabled;
        }

        @Override
        public final Builder loggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public final void setLoggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final Instant getLastSuccessfulDeliveryTime() {
            return lastSuccessfulDeliveryTime;
        }

        @Override
        public final Builder lastSuccessfulDeliveryTime(Instant lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
            return this;
        }

        public final void setLastSuccessfulDeliveryTime(Instant lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
        }

        public final Instant getLastFailureTime() {
            return lastFailureTime;
        }

        @Override
        public final Builder lastFailureTime(Instant lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
            return this;
        }

        public final void setLastFailureTime(Instant lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
        }

        public final String getLastFailureMessage() {
            return lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public EnableLoggingResponse build() {
            return new EnableLoggingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
