/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNodeConfigurationOptionsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeNodeConfigurationOptionsRequest.Builder, DescribeNodeConfigurationOptionsRequest> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNodeConfigurationOptionsRequest::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNodeConfigurationOptionsRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNodeConfigurationOptionsRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNodeConfigurationOptionsRequest::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<List<NodeConfigurationOptionsFilter>> FILTERS_FIELD = SdkField
            .<List<NodeConfigurationOptionsFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNodeConfigurationOptionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeConfigurationOptionsFilter")
                            .memberFieldInfo(
                                    SdkField.<NodeConfigurationOptionsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeConfigurationOptionsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeConfigurationOptionsFilter").build()).build()).build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNodeConfigurationOptionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeNodeConfigurationOptionsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, OWNER_ACCOUNT_FIELD, FILTERS_FIELD, MARKER_FIELD,
            MAX_RECORDS_FIELD));

    private final String actionType;

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final String ownerAccount;

    private final List<NodeConfigurationOptionsFilter> filters;

    private final String marker;

    private final Integer maxRecords;

    private DescribeNodeConfigurationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.ownerAccount = builder.ownerAccount;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
     * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations
     * based on an existing cluster or snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
     *         configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
     *         configuration recommendations based on an existing cluster or snapshot.
     * @see ActionType
     */
    public ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
     * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations
     * based on an existing cluster or snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
     *         configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
     *         configuration recommendations based on an existing cluster or snapshot.
     * @see ActionType
     */
    public String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The identifier of the cluster to evaluate for possible node configurations.
     * </p>
     * 
     * @return The identifier of the cluster to evaluate for possible node configurations.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the snapshot to evaluate for possible node configurations.
     * </p>
     * 
     * @return The identifier of the snapshot to evaluate for possible node configurations.
     */
    public String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not
     * own, optional if you own the snapshot.
     * </p>
     * 
     * @return The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot
     *         you do not own, optional if you own the snapshot.
     */
    public String ownerAccount() {
        return ownerAccount;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of name, operator, and value items to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of name, operator, and value items to filter the results.
     */
    public List<NodeConfigurationOptionsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in <code>MaxRecords</code>, AWS
     * returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in
     *         <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can
     *         retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>500</code>
     * </p>
     * <p>
     * Constraints: minimum 100, maximum 500.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>500</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 100, maximum 500.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeNodeConfigurationOptionsRequest other = (DescribeNodeConfigurationOptionsRequest) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(ownerAccount(), other.ownerAccount()) && Objects.equals(filters(), other.filters())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNodeConfigurationOptionsRequest").add("ActionType", actionTypeAsString())
                .add("ClusterIdentifier", clusterIdentifier()).add("SnapshotIdentifier", snapshotIdentifier())
                .add("OwnerAccount", ownerAccount()).add("Filters", filters()).add("Marker", marker())
                .add("MaxRecords", maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeConfigurationOptionsRequest, T> g) {
        return obj -> g.apply((DescribeNodeConfigurationOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNodeConfigurationOptionsRequest> {
        /**
         * <p>
         * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
         * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration
         * recommendations based on an existing cluster or snapshot.
         * </p>
         * 
         * @param actionType
         *        The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
         *        configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
         *        configuration recommendations based on an existing cluster or snapshot.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration
         * combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration
         * recommendations based on an existing cluster or snapshot.
         * </p>
         * 
         * @param actionType
         *        The action type to evaluate for possible node configurations. Specify "restore-cluster" to get
         *        configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get
         *        configuration recommendations based on an existing cluster or snapshot.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * The identifier of the cluster to evaluate for possible node configurations.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster to evaluate for possible node configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The identifier of the snapshot to evaluate for possible node configurations.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier of the snapshot to evaluate for possible node configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do
         * not own, optional if you own the snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot
         *        you do not own, optional if you own the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * A set of name, operator, and value items to filter the results.
         * </p>
         * 
         * @param filters
         *        A set of name, operator, and value items to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<NodeConfigurationOptionsFilter> filters);

        /**
         * <p>
         * A set of name, operator, and value items to filter the results.
         * </p>
         * 
         * @param filters
         *        A set of name, operator, and value items to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(NodeConfigurationOptionsFilter... filters);

        /**
         * <p>
         * A set of name, operator, and value items to filter the results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeConfigurationOptionsFilter>.Builder}
         * avoiding the need to create one manually via {@link List<NodeConfigurationOptionsFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeConfigurationOptionsFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<NodeConfigurationOptionsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<NodeConfigurationOptionsFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<NodeConfigurationOptionsFilter>)
         */
        Builder filters(Consumer<NodeConfigurationOptionsFilter.Builder>... filters);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in <code>MaxRecords</code>,
         * AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
         * response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
         * request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeNodeConfigurationOptions</a> request exceed the value specified in
         *        <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can
         *        retrieve the next set of response records by providing the returned marker value in the
         *        <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * <p>
         * Default: <code>500</code>
         * </p>
         * <p>
         * Constraints: minimum 100, maximum 500.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value. </p>
         *        <p>
         *        Default: <code>500</code>
         *        </p>
         *        <p>
         *        Constraints: minimum 100, maximum 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String actionType;

        private String clusterIdentifier;

        private String snapshotIdentifier;

        private String ownerAccount;

        private List<NodeConfigurationOptionsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeConfigurationOptionsRequest model) {
            super(model);
            actionType(model.actionType);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            ownerAccount(model.ownerAccount);
            filters(model.filters);
            marker(model.marker);
            maxRecords(model.maxRecords);
        }

        public final String getActionTypeAsString() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final Collection<NodeConfigurationOptionsFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(NodeConfigurationOptionsFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder filters(Collection<NodeConfigurationOptionsFilter> filters) {
            this.filters = NodeConfigurationOptionsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(NodeConfigurationOptionsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<NodeConfigurationOptionsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> NodeConfigurationOptionsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<NodeConfigurationOptionsFilter.BuilderImpl> filters) {
            this.filters = NodeConfigurationOptionsFilterListCopier.copyFromBuilder(filters);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNodeConfigurationOptionsRequest build() {
            return new DescribeNodeConfigurationOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
