/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output from the <a>DescribeClusters</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClustersResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClustersResponse.Builder, DescribeClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClustersResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<Cluster>> CLUSTERS_FIELD = SdkField
            .<List<Cluster>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClustersResponse::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Cluster")
                            .memberFieldInfo(
                                    SdkField.<Cluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Cluster").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CLUSTERS_FIELD));

    private final String marker;

    private final List<Cluster> clusters;

    private DescribeClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusters = builder.clusters;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the Clusters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Cluster</code> objects, where each object describes one cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>Cluster</code> objects, where each object describes one cluster.
     */
    public List<Cluster> clusters() {
        return clusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(clusters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(clusters(), other.clusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClustersResponse").add("Marker", marker()).add("Clusters", clusters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClustersResponse, T> g) {
        return obj -> g.apply((DescribeClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClustersResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <code>Cluster</code> objects, where each object describes one cluster.
         * </p>
         * 
         * @param clusters
         *        A list of <code>Cluster</code> objects, where each object describes one cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<Cluster> clusters);

        /**
         * <p>
         * A list of <code>Cluster</code> objects, where each object describes one cluster.
         * </p>
         * 
         * @param clusters
         *        A list of <code>Cluster</code> objects, where each object describes one cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Cluster... clusters);

        /**
         * <p>
         * A list of <code>Cluster</code> objects, where each object describes one cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Cluster>.Builder} avoiding the need to
         * create one manually via {@link List<Cluster>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cluster>.Builder#build()} is called immediately and its
         * result is passed to {@link #clusters(List<Cluster>)}.
         * 
         * @param clusters
         *        a consumer that will call methods on {@link List<Cluster>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusters(List<Cluster>)
         */
        Builder clusters(Consumer<Cluster.Builder>... clusters);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<Cluster> clusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            super(model);
            marker(model.marker);
            clusters(model.clusters);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Cluster.Builder> getClusters() {
            return clusters != null ? clusters.stream().map(Cluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Cluster... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<Cluster.Builder>... clusters) {
            clusters(Stream.of(clusters).map(c -> Cluster.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusters(Collection<Cluster.BuilderImpl> clusters) {
            this.clusters = ClusterListCopier.copyFromBuilder(clusters);
        }

        @Override
        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
