/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a cluster while it is in the process of resizing with an incremental resize.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTransferProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTransferProgress.Builder, DataTransferProgress> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataTransferProgress::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Double> CURRENT_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DataTransferProgress::currentRateInMegaBytesPerSecond))
            .setter(setter(Builder::currentRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRateInMegaBytesPerSecond")
                    .build()).build();

    private static final SdkField<Long> TOTAL_DATA_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransferProgress::totalDataInMegaBytes)).setter(setter(Builder::totalDataInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalDataInMegaBytes").build())
            .build();

    private static final SdkField<Long> DATA_TRANSFERRED_IN_MEGA_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransferProgress::dataTransferredInMegaBytes))
            .setter(setter(Builder::dataTransferredInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferredInMegaBytes").build())
            .build();

    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransferProgress::estimatedTimeToCompletionInSeconds))
            .setter(setter(Builder::estimatedTimeToCompletionInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds")
                    .build()).build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DataTransferProgress::elapsedTimeInSeconds)).setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CURRENT_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, TOTAL_DATA_IN_MEGA_BYTES_FIELD, DATA_TRANSFERRED_IN_MEGA_BYTES_FIELD,
            ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Double currentRateInMegaBytesPerSecond;

    private final Long totalDataInMegaBytes;

    private final Long dataTransferredInMegaBytes;

    private final Long estimatedTimeToCompletionInSeconds;

    private final Long elapsedTimeInSeconds;

    private DataTransferProgress(BuilderImpl builder) {
        this.status = builder.status;
        this.currentRateInMegaBytesPerSecond = builder.currentRateInMegaBytesPerSecond;
        this.totalDataInMegaBytes = builder.totalDataInMegaBytes;
        this.dataTransferredInMegaBytes = builder.dataTransferredInMegaBytes;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
    }

    /**
     * <p>
     * Describes the status of the cluster. While the transfer is in progress the status is
     * <code>transferringdata</code>.
     * </p>
     * 
     * @return Describes the status of the cluster. While the transfer is in progress the status is
     *         <code>transferringdata</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Describes the data transfer rate in MB's per second.
     * </p>
     * 
     * @return Describes the data transfer rate in MB's per second.
     */
    public Double currentRateInMegaBytesPerSecond() {
        return currentRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * Describes the total amount of data to be transfered in megabytes.
     * </p>
     * 
     * @return Describes the total amount of data to be transfered in megabytes.
     */
    public Long totalDataInMegaBytes() {
        return totalDataInMegaBytes;
    }

    /**
     * <p>
     * Describes the total amount of data that has been transfered in MB's.
     * </p>
     * 
     * @return Describes the total amount of data that has been transfered in MB's.
     */
    public Long dataTransferredInMegaBytes() {
        return dataTransferredInMegaBytes;
    }

    /**
     * <p>
     * Describes the estimated number of seconds remaining to complete the transfer.
     * </p>
     * 
     * @return Describes the estimated number of seconds remaining to complete the transfer.
     */
    public Long estimatedTimeToCompletionInSeconds() {
        return estimatedTimeToCompletionInSeconds;
    }

    /**
     * <p>
     * Describes the number of seconds that have elapsed during the data transfer.
     * </p>
     * 
     * @return Describes the number of seconds that have elapsed during the data transfer.
     */
    public Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(currentRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(totalDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferredInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransferProgress)) {
            return false;
        }
        DataTransferProgress other = (DataTransferProgress) obj;
        return Objects.equals(status(), other.status())
                && Objects.equals(currentRateInMegaBytesPerSecond(), other.currentRateInMegaBytesPerSecond())
                && Objects.equals(totalDataInMegaBytes(), other.totalDataInMegaBytes())
                && Objects.equals(dataTransferredInMegaBytes(), other.dataTransferredInMegaBytes())
                && Objects.equals(estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataTransferProgress").add("Status", status())
                .add("CurrentRateInMegaBytesPerSecond", currentRateInMegaBytesPerSecond())
                .add("TotalDataInMegaBytes", totalDataInMegaBytes())
                .add("DataTransferredInMegaBytes", dataTransferredInMegaBytes())
                .add("EstimatedTimeToCompletionInSeconds", estimatedTimeToCompletionInSeconds())
                .add("ElapsedTimeInSeconds", elapsedTimeInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CurrentRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(currentRateInMegaBytesPerSecond()));
        case "TotalDataInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalDataInMegaBytes()));
        case "DataTransferredInMegaBytes":
            return Optional.ofNullable(clazz.cast(dataTransferredInMegaBytes()));
        case "EstimatedTimeToCompletionInSeconds":
            return Optional.ofNullable(clazz.cast(estimatedTimeToCompletionInSeconds()));
        case "ElapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataTransferProgress, T> g) {
        return obj -> g.apply((DataTransferProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTransferProgress> {
        /**
         * <p>
         * Describes the status of the cluster. While the transfer is in progress the status is
         * <code>transferringdata</code>.
         * </p>
         * 
         * @param status
         *        Describes the status of the cluster. While the transfer is in progress the status is
         *        <code>transferringdata</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Describes the data transfer rate in MB's per second.
         * </p>
         * 
         * @param currentRateInMegaBytesPerSecond
         *        Describes the data transfer rate in MB's per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond);

        /**
         * <p>
         * Describes the total amount of data to be transfered in megabytes.
         * </p>
         * 
         * @param totalDataInMegaBytes
         *        Describes the total amount of data to be transfered in megabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDataInMegaBytes(Long totalDataInMegaBytes);

        /**
         * <p>
         * Describes the total amount of data that has been transfered in MB's.
         * </p>
         * 
         * @param dataTransferredInMegaBytes
         *        Describes the total amount of data that has been transfered in MB's.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferredInMegaBytes(Long dataTransferredInMegaBytes);

        /**
         * <p>
         * Describes the estimated number of seconds remaining to complete the transfer.
         * </p>
         * 
         * @param estimatedTimeToCompletionInSeconds
         *        Describes the estimated number of seconds remaining to complete the transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds);

        /**
         * <p>
         * Describes the number of seconds that have elapsed during the data transfer.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        Describes the number of seconds that have elapsed during the data transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Double currentRateInMegaBytesPerSecond;

        private Long totalDataInMegaBytes;

        private Long dataTransferredInMegaBytes;

        private Long estimatedTimeToCompletionInSeconds;

        private Long elapsedTimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransferProgress model) {
            status(model.status);
            currentRateInMegaBytesPerSecond(model.currentRateInMegaBytesPerSecond);
            totalDataInMegaBytes(model.totalDataInMegaBytes);
            dataTransferredInMegaBytes(model.dataTransferredInMegaBytes);
            estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Double getCurrentRateInMegaBytesPerSecond() {
            return currentRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond) {
            this.currentRateInMegaBytesPerSecond = currentRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond) {
            this.currentRateInMegaBytesPerSecond = currentRateInMegaBytesPerSecond;
        }

        public final Long getTotalDataInMegaBytes() {
            return totalDataInMegaBytes;
        }

        @Override
        public final Builder totalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
            return this;
        }

        public final void setTotalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
        }

        public final Long getDataTransferredInMegaBytes() {
            return dataTransferredInMegaBytes;
        }

        @Override
        public final Builder dataTransferredInMegaBytes(Long dataTransferredInMegaBytes) {
            this.dataTransferredInMegaBytes = dataTransferredInMegaBytes;
            return this;
        }

        public final void setDataTransferredInMegaBytes(Long dataTransferredInMegaBytes) {
            this.dataTransferredInMegaBytes = dataTransferredInMegaBytes;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        public DataTransferProgress build() {
            return new DataTransferProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
