/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyClusterSnapshotRequest extends RedshiftRequest implements
        ToCopyableBuilder<CopyClusterSnapshotRequest.Builder, CopyClusterSnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyClusterSnapshotRequest::sourceSnapshotIdentifier))
            .setter(setter(Builder::sourceSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyClusterSnapshotRequest::sourceSnapshotClusterIdentifier))
            .setter(setter(Builder::sourceSnapshotClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotClusterIdentifier")
                    .build()).build();

    private static final SdkField<String> TARGET_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyClusterSnapshotRequest::targetSnapshotIdentifier))
            .setter(setter(Builder::targetSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSnapshotIdentifier").build())
            .build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CopyClusterSnapshotRequest::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_SNAPSHOT_IDENTIFIER_FIELD, SOURCE_SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, TARGET_SNAPSHOT_IDENTIFIER_FIELD,
            MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD));

    private final String sourceSnapshotIdentifier;

    private final String sourceSnapshotClusterIdentifier;

    private final String targetSnapshotIdentifier;

    private final Integer manualSnapshotRetentionPeriod;

    private CopyClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotIdentifier = builder.sourceSnapshotIdentifier;
        this.sourceSnapshotClusterIdentifier = builder.sourceSnapshotClusterIdentifier;
        this.targetSnapshotIdentifier = builder.targetSnapshotIdentifier;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The identifier for the source snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be the identifier for a valid automated snapshot whose state is <code>available</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the source snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be the identifier for a valid automated snapshot whose state is <code>available</code>.
     *         </p>
     *         </li>
     */
    public String sourceSnapshotIdentifier() {
        return sourceSnapshotIdentifier;
    }

    /**
     * <p>
     * The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user
     * has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be the identifier for a valid cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the cluster the source snapshot was created from. This parameter is required if your
     *         IAM user has a policy containing a snapshot resource element that specifies anything other than * for the
     *         cluster name.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be the identifier for a valid cluster.
     *         </p>
     *         </li>
     */
    public String sourceSnapshotClusterIdentifier() {
        return sourceSnapshotClusterIdentifier;
    }

    /**
     * <p>
     * The identifier given to the new manual snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cannot be null, empty, or blank.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain from 1 to 255 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be unique for the AWS account that is making the request.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier given to the new manual snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot be null, empty, or blank.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain from 1 to 255 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be unique for the AWS account that is making the request.
     *         </p>
     *         </li>
     */
    public String targetSnapshotIdentifier() {
        return targetSnapshotIdentifier;
    }

    /**
     * <p>
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
     * indefinitely.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * <p>
     * The default value is -1.
     * </p>
     * 
     * @return The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
     *         retained indefinitely. </p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     *         </p>
     *         <p>
     *         The default value is -1.
     */
    public Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyClusterSnapshotRequest)) {
            return false;
        }
        CopyClusterSnapshotRequest other = (CopyClusterSnapshotRequest) obj;
        return Objects.equals(sourceSnapshotIdentifier(), other.sourceSnapshotIdentifier())
                && Objects.equals(sourceSnapshotClusterIdentifier(), other.sourceSnapshotClusterIdentifier())
                && Objects.equals(targetSnapshotIdentifier(), other.targetSnapshotIdentifier())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CopyClusterSnapshotRequest").add("SourceSnapshotIdentifier", sourceSnapshotIdentifier())
                .add("SourceSnapshotClusterIdentifier", sourceSnapshotClusterIdentifier())
                .add("TargetSnapshotIdentifier", targetSnapshotIdentifier())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(sourceSnapshotIdentifier()));
        case "SourceSnapshotClusterIdentifier":
            return Optional.ofNullable(clazz.cast(sourceSnapshotClusterIdentifier()));
        case "TargetSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(targetSnapshotIdentifier()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyClusterSnapshotRequest, T> g) {
        return obj -> g.apply((CopyClusterSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyClusterSnapshotRequest> {
        /**
         * <p>
         * The identifier for the source snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be the identifier for a valid automated snapshot whose state is <code>available</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceSnapshotIdentifier
         *        The identifier for the source snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be the identifier for a valid automated snapshot whose state is <code>available</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotIdentifier(String sourceSnapshotIdentifier);

        /**
         * <p>
         * The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM
         * user has a policy containing a snapshot resource element that specifies anything other than * for the cluster
         * name.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be the identifier for a valid cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceSnapshotClusterIdentifier
         *        The identifier of the cluster the source snapshot was created from. This parameter is required if your
         *        IAM user has a policy containing a snapshot resource element that specifies anything other than * for
         *        the cluster name.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be the identifier for a valid cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotClusterIdentifier(String sourceSnapshotClusterIdentifier);

        /**
         * <p>
         * The identifier given to the new manual snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cannot be null, empty, or blank.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be unique for the AWS account that is making the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetSnapshotIdentifier
         *        The identifier given to the new manual snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cannot be null, empty, or blank.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain from 1 to 255 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be unique for the AWS account that is making the request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSnapshotIdentifier(String targetSnapshotIdentifier);

        /**
         * <p>
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
         * indefinitely.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * <p>
         * The default value is -1.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
         *        retained indefinitely. </p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         *        </p>
         *        <p>
         *        The default value is -1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String sourceSnapshotIdentifier;

        private String sourceSnapshotClusterIdentifier;

        private String targetSnapshotIdentifier;

        private Integer manualSnapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyClusterSnapshotRequest model) {
            super(model);
            sourceSnapshotIdentifier(model.sourceSnapshotIdentifier);
            sourceSnapshotClusterIdentifier(model.sourceSnapshotClusterIdentifier);
            targetSnapshotIdentifier(model.targetSnapshotIdentifier);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
        }

        public final String getSourceSnapshotIdentifier() {
            return sourceSnapshotIdentifier;
        }

        @Override
        public final Builder sourceSnapshotIdentifier(String sourceSnapshotIdentifier) {
            this.sourceSnapshotIdentifier = sourceSnapshotIdentifier;
            return this;
        }

        public final void setSourceSnapshotIdentifier(String sourceSnapshotIdentifier) {
            this.sourceSnapshotIdentifier = sourceSnapshotIdentifier;
        }

        public final String getSourceSnapshotClusterIdentifier() {
            return sourceSnapshotClusterIdentifier;
        }

        @Override
        public final Builder sourceSnapshotClusterIdentifier(String sourceSnapshotClusterIdentifier) {
            this.sourceSnapshotClusterIdentifier = sourceSnapshotClusterIdentifier;
            return this;
        }

        public final void setSourceSnapshotClusterIdentifier(String sourceSnapshotClusterIdentifier) {
            this.sourceSnapshotClusterIdentifier = sourceSnapshotClusterIdentifier;
        }

        public final String getTargetSnapshotIdentifier() {
            return targetSnapshotIdentifier;
        }

        @Override
        public final Builder targetSnapshotIdentifier(String targetSnapshotIdentifier) {
            this.targetSnapshotIdentifier = targetSnapshotIdentifier;
            return this;
        }

        public final void setTargetSnapshotIdentifier(String targetSnapshotIdentifier) {
            this.targetSnapshotIdentifier = targetSnapshotIdentifier;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyClusterSnapshotRequest build() {
            return new CopyClusterSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
