/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.AvailabilityZone;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;
import software.amazon.awssdk.services.redshift.transform.AvailabilityZoneUnmarshaller;

public class OrderableClusterOptionUnmarshaller
implements Unmarshaller<OrderableClusterOption, StaxUnmarshallerContext> {
    private static final OrderableClusterOptionUnmarshaller INSTANCE = new OrderableClusterOptionUnmarshaller();

    public OrderableClusterOption unmarshall(StaxUnmarshallerContext context) throws Exception {
        OrderableClusterOption.Builder orderableClusterOption;
        block8: {
            orderableClusterOption = OrderableClusterOption.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<AvailabilityZone> availabilityZones = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    orderableClusterOption.availabilityZones(availabilityZones);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ClusterVersion", targetDepth)) {
                        orderableClusterOption.clusterVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ClusterType", targetDepth)) {
                        orderableClusterOption.clusterType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NodeType", targetDepth)) {
                        orderableClusterOption.nodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones", targetDepth)) {
                        availabilityZones = new ArrayList<AvailabilityZone>();
                        continue;
                    }
                    if (!context.testExpression("AvailabilityZones/AvailabilityZone", targetDepth)) continue;
                    availabilityZones.add(AvailabilityZoneUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            orderableClusterOption.availabilityZones(availabilityZones);
        }
        return (OrderableClusterOption)orderableClusterOption.build();
    }

    public static OrderableClusterOptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

