/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;

public class ModifyEventSubscriptionRequestMarshaller
implements Marshaller<Request<ModifyEventSubscriptionRequest>, ModifyEventSubscriptionRequest> {
    public Request<ModifyEventSubscriptionRequest> marshall(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        List<String> eventCategoriesList;
        List<String> sourceIdsList;
        if (modifyEventSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyEventSubscriptionRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyEventSubscription");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyEventSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString((String)modifyEventSubscriptionRequest.subscriptionName()));
        }
        if (modifyEventSubscriptionRequest.snsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringUtils.fromString((String)modifyEventSubscriptionRequest.snsTopicArn()));
        }
        if (modifyEventSubscriptionRequest.sourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)modifyEventSubscriptionRequest.sourceType()));
        }
        if ((sourceIdsList = modifyEventSubscriptionRequest.sourceIds()) != null) {
            if (!sourceIdsList.isEmpty()) {
                int sourceIdsListIndex = 1;
                for (String sourceIdsListValue : sourceIdsList) {
                    if (sourceIdsListValue != null) {
                        request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringUtils.fromString((String)sourceIdsListValue));
                    }
                    ++sourceIdsListIndex;
                }
            } else {
                request.addParameter("SourceIds", "");
            }
        }
        if ((eventCategoriesList = modifyEventSubscriptionRequest.eventCategories()) != null) {
            if (!eventCategoriesList.isEmpty()) {
                int eventCategoriesListIndex = 1;
                for (String eventCategoriesListValue : eventCategoriesList) {
                    if (eventCategoriesListValue != null) {
                        request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)eventCategoriesListValue));
                    }
                    ++eventCategoriesListIndex;
                }
            } else {
                request.addParameter("EventCategories", "");
            }
        }
        if (modifyEventSubscriptionRequest.severity() != null) {
            request.addParameter("Severity", StringUtils.fromString((String)modifyEventSubscriptionRequest.severity()));
        }
        if (modifyEventSubscriptionRequest.enabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)modifyEventSubscriptionRequest.enabled()));
        }
        return request;
    }
}

