/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;

public class DescribeClusterVersionsIterable
implements SdkIterable<DescribeClusterVersionsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterVersionsIterable(RedshiftClient client, DescribeClusterVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterVersionsResponseFetcher();
    }

    public Iterator<DescribeClusterVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ClusterVersion> clusterVersions() {
        Function<DescribeClusterVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterVersions() != null) {
                return response.clusterVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeClusterVersionsIterable resume(DescribeClusterVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterVersionsIterable(this.client, (DescribeClusterVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClusterVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClusterVersionsResponseFetcher
    implements SyncPageFetcher<DescribeClusterVersionsResponse> {
        private DescribeClusterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterVersionsResponse nextPage(DescribeClusterVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterVersionsIterable.this.client.describeClusterVersions(DescribeClusterVersionsIterable.this.firstRequest);
            }
            return DescribeClusterVersionsIterable.this.client.describeClusterVersions((DescribeClusterVersionsRequest)((Object)DescribeClusterVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

