/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PendingModifiedValues
implements ToCopyableBuilder<Builder, PendingModifiedValues> {
    private final String masterUserPassword;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final String clusterType;
    private final String clusterVersion;
    private final Integer automatedSnapshotRetentionPeriod;
    private final String clusterIdentifier;
    private final Boolean publiclyAccessible;
    private final Boolean enhancedVpcRouting;

    private PendingModifiedValues(BuilderImpl builder) {
        this.masterUserPassword = builder.masterUserPassword;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.clusterType = builder.clusterType;
        this.clusterVersion = builder.clusterVersion;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public String clusterType() {
        return this.clusterType;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.masterUserPassword() == null ? 0 : this.masterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.numberOfNodes() == null ? 0 : this.numberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.clusterType() == null ? 0 : this.clusterType().hashCode());
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.automatedSnapshotRetentionPeriod() == null ? 0 : this.automatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.publiclyAccessible() == null ? 0 : this.publiclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.enhancedVpcRouting() == null ? 0 : this.enhancedVpcRouting().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues)obj;
        if (other.masterUserPassword() == null ^ this.masterUserPassword() == null) {
            return false;
        }
        if (other.masterUserPassword() != null && !other.masterUserPassword().equals(this.masterUserPassword())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.numberOfNodes() == null ^ this.numberOfNodes() == null) {
            return false;
        }
        if (other.numberOfNodes() != null && !other.numberOfNodes().equals(this.numberOfNodes())) {
            return false;
        }
        if (other.clusterType() == null ^ this.clusterType() == null) {
            return false;
        }
        if (other.clusterType() != null && !other.clusterType().equals(this.clusterType())) {
            return false;
        }
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() == null ^ this.automatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() != null && !other.automatedSnapshotRetentionPeriod().equals(this.automatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.publiclyAccessible() == null ^ this.publiclyAccessible() == null) {
            return false;
        }
        if (other.publiclyAccessible() != null && !other.publiclyAccessible().equals(this.publiclyAccessible())) {
            return false;
        }
        if (other.enhancedVpcRouting() == null ^ this.enhancedVpcRouting() == null) {
            return false;
        }
        return other.enhancedVpcRouting() == null || other.enhancedVpcRouting().equals(this.enhancedVpcRouting());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.masterUserPassword() != null) {
            sb.append("MasterUserPassword: ").append(this.masterUserPassword()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.numberOfNodes() != null) {
            sb.append("NumberOfNodes: ").append(this.numberOfNodes()).append(",");
        }
        if (this.clusterType() != null) {
            sb.append("ClusterType: ").append(this.clusterType()).append(",");
        }
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.automatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: ").append(this.automatedSnapshotRetentionPeriod()).append(",");
        }
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.enhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: ").append(this.enhancedVpcRouting()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MasterUserPassword": {
                return Optional.of(clazz.cast(this.masterUserPassword()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.of(clazz.cast(this.numberOfNodes()));
            }
            case "ClusterType": {
                return Optional.of(clazz.cast(this.clusterType()));
            }
            case "ClusterVersion": {
                return Optional.of(clazz.cast(this.clusterVersion()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.of(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "PubliclyAccessible": {
                return Optional.of(clazz.cast(this.publiclyAccessible()));
            }
            case "EnhancedVpcRouting": {
                return Optional.of(clazz.cast(this.enhancedVpcRouting()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String masterUserPassword;
        private String nodeType;
        private Integer numberOfNodes;
        private String clusterType;
        private String clusterVersion;
        private Integer automatedSnapshotRetentionPeriod;
        private String clusterIdentifier;
        private Boolean publiclyAccessible;
        private Boolean enhancedVpcRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            this.masterUserPassword(model.masterUserPassword);
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.clusterType(model.clusterType);
            this.clusterVersion(model.clusterVersion);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.clusterIdentifier(model.clusterIdentifier);
            this.publiclyAccessible(model.publiclyAccessible);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PendingModifiedValues> {
        public Builder masterUserPassword(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder clusterType(String var1);

        public Builder clusterVersion(String var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder clusterIdentifier(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder enhancedVpcRouting(Boolean var1);
    }
}

