/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterNode
implements ToCopyableBuilder<Builder, ClusterNode> {
    private final String nodeRole;
    private final String privateIPAddress;
    private final String publicIPAddress;

    private ClusterNode(BuilderImpl builder) {
        this.nodeRole = builder.nodeRole;
        this.privateIPAddress = builder.privateIPAddress;
        this.publicIPAddress = builder.publicIPAddress;
    }

    public String nodeRole() {
        return this.nodeRole;
    }

    public String privateIPAddress() {
        return this.privateIPAddress;
    }

    public String publicIPAddress() {
        return this.publicIPAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nodeRole() == null ? 0 : this.nodeRole().hashCode());
        hashCode = 31 * hashCode + (this.privateIPAddress() == null ? 0 : this.privateIPAddress().hashCode());
        hashCode = 31 * hashCode + (this.publicIPAddress() == null ? 0 : this.publicIPAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode other = (ClusterNode)obj;
        if (other.nodeRole() == null ^ this.nodeRole() == null) {
            return false;
        }
        if (other.nodeRole() != null && !other.nodeRole().equals(this.nodeRole())) {
            return false;
        }
        if (other.privateIPAddress() == null ^ this.privateIPAddress() == null) {
            return false;
        }
        if (other.privateIPAddress() != null && !other.privateIPAddress().equals(this.privateIPAddress())) {
            return false;
        }
        if (other.publicIPAddress() == null ^ this.publicIPAddress() == null) {
            return false;
        }
        return other.publicIPAddress() == null || other.publicIPAddress().equals(this.publicIPAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nodeRole() != null) {
            sb.append("NodeRole: ").append(this.nodeRole()).append(",");
        }
        if (this.privateIPAddress() != null) {
            sb.append("PrivateIPAddress: ").append(this.privateIPAddress()).append(",");
        }
        if (this.publicIPAddress() != null) {
            sb.append("PublicIPAddress: ").append(this.publicIPAddress()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeRole": {
                return Optional.of(clazz.cast(this.nodeRole()));
            }
            case "PrivateIPAddress": {
                return Optional.of(clazz.cast(this.privateIPAddress()));
            }
            case "PublicIPAddress": {
                return Optional.of(clazz.cast(this.publicIPAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeRole;
        private String privateIPAddress;
        private String publicIPAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNode model) {
            this.nodeRole(model.nodeRole);
            this.privateIPAddress(model.privateIPAddress);
            this.publicIPAddress(model.publicIPAddress);
        }

        public final String getNodeRole() {
            return this.nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        public final String getPrivateIPAddress() {
            return this.privateIPAddress;
        }

        @Override
        public final Builder privateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
            return this;
        }

        public final void setPrivateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
        }

        public final String getPublicIPAddress() {
            return this.publicIPAddress;
        }

        @Override
        public final Builder publicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
            return this;
        }

        public final void setPublicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
        }

        public ClusterNode build() {
            return new ClusterNode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterNode> {
        public Builder nodeRole(String var1);

        public Builder privateIPAddress(String var1);

        public Builder publicIPAddress(String var1);
    }
}

