/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.RebootClusterRequest;
import software.amazon.awssdk.util.StringUtils;

public class RebootClusterRequestMarshaller
implements Marshaller<Request<RebootClusterRequest>, RebootClusterRequest> {
    public Request<RebootClusterRequest> marshall(RebootClusterRequest rebootClusterRequest) {
        if (rebootClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootClusterRequest, "RedshiftClient");
        request.addParameter("Action", "RebootCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebootClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)rebootClusterRequest.clusterIdentifier()));
        }
        return request;
    }
}

