/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest;
import software.amazon.awssdk.util.StringUtils;

public class AuthorizeSnapshotAccessRequestMarshaller
implements Marshaller<Request<AuthorizeSnapshotAccessRequest>, AuthorizeSnapshotAccessRequest> {
    public Request<AuthorizeSnapshotAccessRequest> marshall(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) {
        if (authorizeSnapshotAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeSnapshotAccessRequest, "RedshiftClient");
        request.addParameter("Action", "AuthorizeSnapshotAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSnapshotAccessRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)authorizeSnapshotAccessRequest.snapshotIdentifier()));
        }
        if (authorizeSnapshotAccessRequest.snapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)authorizeSnapshotAccessRequest.snapshotClusterIdentifier()));
        }
        if (authorizeSnapshotAccessRequest.accountWithRestoreAccess() != null) {
            request.addParameter("AccountWithRestoreAccess", StringUtils.fromString((String)authorizeSnapshotAccessRequest.accountWithRestoreAccess()));
        }
        return request;
    }
}

