/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventInfoMap
implements ToCopyableBuilder<Builder, EventInfoMap> {
    private final String eventId;
    private final List<String> eventCategories;
    private final String eventDescription;
    private final String severity;

    private EventInfoMap(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventCategories = builder.eventCategories;
        this.eventDescription = builder.eventDescription;
        this.severity = builder.severity;
    }

    public String eventId() {
        return this.eventId;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public String eventDescription() {
        return this.eventDescription;
    }

    public String severity() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventId() == null ? 0 : this.eventId().hashCode());
        hashCode = 31 * hashCode + (this.eventCategories() == null ? 0 : this.eventCategories().hashCode());
        hashCode = 31 * hashCode + (this.eventDescription() == null ? 0 : this.eventDescription().hashCode());
        hashCode = 31 * hashCode + (this.severity() == null ? 0 : this.severity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInfoMap)) {
            return false;
        }
        EventInfoMap other = (EventInfoMap)obj;
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.eventCategories() == null ^ this.eventCategories() == null) {
            return false;
        }
        if (other.eventCategories() != null && !other.eventCategories().equals(this.eventCategories())) {
            return false;
        }
        if (other.eventDescription() == null ^ this.eventDescription() == null) {
            return false;
        }
        if (other.eventDescription() != null && !other.eventDescription().equals(this.eventDescription())) {
            return false;
        }
        if (other.severity() == null ^ this.severity() == null) {
            return false;
        }
        return other.severity() == null || other.severity().equals(this.severity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventId() != null) {
            sb.append("EventId: ").append(this.eventId()).append(",");
        }
        if (this.eventCategories() != null) {
            sb.append("EventCategories: ").append(this.eventCategories()).append(",");
        }
        if (this.eventDescription() != null) {
            sb.append("EventDescription: ").append(this.eventDescription()).append(",");
        }
        if (this.severity() != null) {
            sb.append("Severity: ").append(this.severity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String eventId;
        private List<String> eventCategories;
        private String eventDescription;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventInfoMap model) {
            this.setEventId(model.eventId);
            this.setEventCategories(model.eventCategories);
            this.setEventDescription(model.eventDescription);
            this.setSeverity(model.severity);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final String getEventDescription() {
            return this.eventDescription;
        }

        @Override
        public final Builder eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public EventInfoMap build() {
            return new EventInfoMap(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventInfoMap> {
        public Builder eventId(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder eventDescription(String var1);

        public Builder severity(String var1);
    }
}

