/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterVersionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeClusterVersionsRequest> {
    private final String clusterVersion;
    private final String clusterParameterGroupFamily;
    private final Integer maxRecords;
    private final String marker;

    private DescribeClusterVersionsRequest(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterParameterGroupFamily = builder.clusterParameterGroupFamily;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String clusterParameterGroupFamily() {
        return this.clusterParameterGroupFamily;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.clusterParameterGroupFamily() == null ? 0 : this.clusterParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsRequest)) {
            return false;
        }
        DescribeClusterVersionsRequest other = (DescribeClusterVersionsRequest)((Object)obj);
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.clusterParameterGroupFamily() == null ^ this.clusterParameterGroupFamily() == null) {
            return false;
        }
        if (other.clusterParameterGroupFamily() != null && !other.clusterParameterGroupFamily().equals(this.clusterParameterGroupFamily())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.clusterParameterGroupFamily() != null) {
            sb.append("ClusterParameterGroupFamily: ").append(this.clusterParameterGroupFamily()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String clusterParameterGroupFamily;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsRequest model) {
            this.setClusterVersion(model.clusterVersion);
            this.setClusterParameterGroupFamily(model.clusterParameterGroupFamily);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getClusterParameterGroupFamily() {
            return this.clusterParameterGroupFamily;
        }

        @Override
        public final Builder clusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
            return this;
        }

        public final void setClusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeClusterVersionsRequest build() {
            return new DescribeClusterVersionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterVersionsRequest> {
        public Builder clusterVersion(String var1);

        public Builder clusterParameterGroupFamily(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

