/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.HsmConfiguration;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHsmConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHsmConfigurationsResponse> {
    private final String marker;
    private final List<HsmConfiguration> hsmConfigurations;

    private DescribeHsmConfigurationsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.hsmConfigurations = builder.hsmConfigurations;
    }

    public String marker() {
        return this.marker;
    }

    public List<HsmConfiguration> hsmConfigurations() {
        return this.hsmConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.hsmConfigurations() == null ? 0 : this.hsmConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmConfigurationsResponse)) {
            return false;
        }
        DescribeHsmConfigurationsResponse other = (DescribeHsmConfigurationsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.hsmConfigurations() == null ^ this.hsmConfigurations() == null) {
            return false;
        }
        return other.hsmConfigurations() == null || other.hsmConfigurations().equals(this.hsmConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.hsmConfigurations() != null) {
            sb.append("HsmConfigurations: ").append(this.hsmConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<HsmConfiguration> hsmConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmConfigurationsResponse model) {
            this.setMarker(model.marker);
            this.setHsmConfigurations(model.hsmConfigurations);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<HsmConfiguration> getHsmConfigurations() {
            return this.hsmConfigurations;
        }

        @Override
        public final Builder hsmConfigurations(Collection<HsmConfiguration> hsmConfigurations) {
            this.hsmConfigurations = HsmConfigurationListCopier.copy(hsmConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmConfigurations(HsmConfiguration ... hsmConfigurations) {
            this.hsmConfigurations(Arrays.asList(hsmConfigurations));
            return this;
        }

        public final void setHsmConfigurations(Collection<HsmConfiguration> hsmConfigurations) {
            this.hsmConfigurations = HsmConfigurationListCopier.copy(hsmConfigurations);
        }

        @SafeVarargs
        public final void setHsmConfigurations(HsmConfiguration ... hsmConfigurations) {
            this.hsmConfigurations(Arrays.asList(hsmConfigurations));
        }

        public DescribeHsmConfigurationsResponse build() {
            return new DescribeHsmConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHsmConfigurationsResponse> {
        public Builder marker(String var1);

        public Builder hsmConfigurations(Collection<HsmConfiguration> var1);

        public Builder hsmConfigurations(HsmConfiguration ... var1);
    }
}

