/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterSubnetGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeClusterSubnetGroupsResponse> {
    private final String marker;
    private final List<ClusterSubnetGroup> clusterSubnetGroups;

    private DescribeClusterSubnetGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.clusterSubnetGroups = builder.clusterSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterSubnetGroup> clusterSubnetGroups() {
        return this.clusterSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.clusterSubnetGroups() == null ? 0 : this.clusterSubnetGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSubnetGroupsResponse)) {
            return false;
        }
        DescribeClusterSubnetGroupsResponse other = (DescribeClusterSubnetGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.clusterSubnetGroups() == null ^ this.clusterSubnetGroups() == null) {
            return false;
        }
        return other.clusterSubnetGroups() == null || other.clusterSubnetGroups().equals(this.clusterSubnetGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.clusterSubnetGroups() != null) {
            sb.append("ClusterSubnetGroups: ").append(this.clusterSubnetGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterSubnetGroup> clusterSubnetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSubnetGroupsResponse model) {
            this.setMarker(model.marker);
            this.setClusterSubnetGroups(model.clusterSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterSubnetGroup> getClusterSubnetGroups() {
            return this.clusterSubnetGroups;
        }

        @Override
        public final Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copy(clusterSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSubnetGroups(ClusterSubnetGroup ... clusterSubnetGroups) {
            this.clusterSubnetGroups(Arrays.asList(clusterSubnetGroups));
            return this;
        }

        public final void setClusterSubnetGroups(Collection<ClusterSubnetGroup> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copy(clusterSubnetGroups);
        }

        @SafeVarargs
        public final void setClusterSubnetGroups(ClusterSubnetGroup ... clusterSubnetGroups) {
            this.clusterSubnetGroups(Arrays.asList(clusterSubnetGroups));
        }

        public DescribeClusterSubnetGroupsResponse build() {
            return new DescribeClusterSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> var1);

        public Builder clusterSubnetGroups(ClusterSubnetGroup ... var1);
    }
}

