/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteClusterRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DeleteClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteClusterRequest.getter(DeleteClusterRequest::clusterIdentifier)).setter(DeleteClusterRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> SKIP_FINAL_CLUSTER_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteClusterRequest.getter(DeleteClusterRequest::skipFinalClusterSnapshot)).setter(DeleteClusterRequest.setter(Builder::skipFinalClusterSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalClusterSnapshot").build()}).build();
    private static final SdkField<String> FINAL_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteClusterRequest.getter(DeleteClusterRequest::finalClusterSnapshotIdentifier)).setter(DeleteClusterRequest.setter(Builder::finalClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalClusterSnapshotIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, SKIP_FINAL_CLUSTER_SNAPSHOT_FIELD, FINAL_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD));
    private final String clusterIdentifier;
    private final Boolean skipFinalClusterSnapshot;
    private final String finalClusterSnapshotIdentifier;

    private DeleteClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.skipFinalClusterSnapshot = builder.skipFinalClusterSnapshot;
        this.finalClusterSnapshotIdentifier = builder.finalClusterSnapshotIdentifier;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Boolean skipFinalClusterSnapshot() {
        return this.skipFinalClusterSnapshot;
    }

    public String finalClusterSnapshotIdentifier() {
        return this.finalClusterSnapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalClusterSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalClusterSnapshotIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterRequest)) {
            return false;
        }
        DeleteClusterRequest other = (DeleteClusterRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.skipFinalClusterSnapshot(), other.skipFinalClusterSnapshot()) && Objects.equals(this.finalClusterSnapshotIdentifier(), other.finalClusterSnapshotIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"DeleteClusterRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SkipFinalClusterSnapshot", (Object)this.skipFinalClusterSnapshot()).add("FinalClusterSnapshotIdentifier", (Object)this.finalClusterSnapshotIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SkipFinalClusterSnapshot": {
                return Optional.ofNullable(clazz.cast(this.skipFinalClusterSnapshot()));
            }
            case "FinalClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.finalClusterSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterRequest, T> g) {
        return obj -> g.apply((DeleteClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Boolean skipFinalClusterSnapshot;
        private String finalClusterSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.skipFinalClusterSnapshot(model.skipFinalClusterSnapshot);
            this.finalClusterSnapshotIdentifier(model.finalClusterSnapshotIdentifier);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Boolean getSkipFinalClusterSnapshot() {
            return this.skipFinalClusterSnapshot;
        }

        @Override
        public final Builder skipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
            return this;
        }

        public final void setSkipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
        }

        public final String getFinalClusterSnapshotIdentifier() {
            return this.finalClusterSnapshotIdentifier;
        }

        @Override
        public final Builder finalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
            return this;
        }

        public final void setFinalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClusterRequest build() {
            return new DeleteClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder skipFinalClusterSnapshot(Boolean var1);

        public Builder finalClusterSnapshotIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

