/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.RestoreStatus;

public class RestoreStatusUnmarshaller
implements Unmarshaller<RestoreStatus, StaxUnmarshallerContext> {
    private static final RestoreStatusUnmarshaller INSTANCE = new RestoreStatusUnmarshaller();

    public RestoreStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RestoreStatus.Builder restoreStatus = RestoreStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    restoreStatus.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CurrentRestoreRateInMegaBytesPerSecond", targetDepth)) {
                    restoreStatus.currentRestoreRateInMegaBytesPerSecond(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SnapshotSizeInMegaBytes", targetDepth)) {
                    restoreStatus.snapshotSizeInMegaBytes(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProgressInMegaBytes", targetDepth)) {
                    restoreStatus.progressInMegaBytes(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ElapsedTimeInSeconds", targetDepth)) {
                    restoreStatus.elapsedTimeInSeconds(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EstimatedTimeToCompletionInSeconds", targetDepth)) continue;
                restoreStatus.estimatedTimeToCompletionInSeconds(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RestoreStatus)restoreStatus.build();
    }

    public static RestoreStatusUnmarshaller getInstance() {
        return INSTANCE;
    }
}

