/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;

public class ModifyEventSubscriptionRequestMarshaller
implements Marshaller<Request<ModifyEventSubscriptionRequest>, ModifyEventSubscriptionRequest> {
    public Request<ModifyEventSubscriptionRequest> marshall(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        if (modifyEventSubscriptionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyEventSubscriptionRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyEventSubscription");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyEventSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringConversion.fromString((String)modifyEventSubscriptionRequest.subscriptionName()));
        }
        if (modifyEventSubscriptionRequest.snsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringConversion.fromString((String)modifyEventSubscriptionRequest.snsTopicArn()));
        }
        if (modifyEventSubscriptionRequest.sourceType() != null) {
            request.addParameter("SourceType", StringConversion.fromString((String)modifyEventSubscriptionRequest.sourceType()));
        }
        if (modifyEventSubscriptionRequest.sourceIds().isEmpty() && !(modifyEventSubscriptionRequest.sourceIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SourceIds", "");
        } else if (!modifyEventSubscriptionRequest.sourceIds().isEmpty() && !(modifyEventSubscriptionRequest.sourceIds() instanceof SdkAutoConstructList)) {
            List<String> sourceIdsList = modifyEventSubscriptionRequest.sourceIds();
            int sourceIdsListIndex = 1;
            for (String sourceIdsListValue : sourceIdsList) {
                if (sourceIdsListValue != null) {
                    request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringConversion.fromString((String)sourceIdsListValue));
                }
                ++sourceIdsListIndex;
            }
        }
        if (modifyEventSubscriptionRequest.eventCategories().isEmpty() && !(modifyEventSubscriptionRequest.eventCategories() instanceof SdkAutoConstructList)) {
            request.addParameter("EventCategories", "");
        } else if (!modifyEventSubscriptionRequest.eventCategories().isEmpty() && !(modifyEventSubscriptionRequest.eventCategories() instanceof SdkAutoConstructList)) {
            List<String> eventCategoriesList = modifyEventSubscriptionRequest.eventCategories();
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringConversion.fromString((String)eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (modifyEventSubscriptionRequest.severity() != null) {
            request.addParameter("Severity", StringConversion.fromString((String)modifyEventSubscriptionRequest.severity()));
        }
        if (modifyEventSubscriptionRequest.enabled() != null) {
            request.addParameter("Enabled", StringConversion.fromBoolean((Boolean)modifyEventSubscriptionRequest.enabled()));
        }
        return request;
    }
}

