/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeTagsRequest;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        if (describeTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeTagsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTagsRequest.resourceName() != null) {
            request.addParameter("ResourceName", StringConversion.fromString((String)describeTagsRequest.resourceName()));
        }
        if (describeTagsRequest.resourceType() != null) {
            request.addParameter("ResourceType", StringConversion.fromString((String)describeTagsRequest.resourceType()));
        }
        if (describeTagsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeTagsRequest.maxRecords()));
        }
        if (describeTagsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeTagsRequest.marker()));
        }
        if (describeTagsRequest.tagKeys().isEmpty() && !(describeTagsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeTagsRequest.tagKeys().isEmpty() && !(describeTagsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeTagsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeTagsRequest.tagValues().isEmpty() && !(describeTagsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeTagsRequest.tagValues().isEmpty() && !(describeTagsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeTagsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

