/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;

public class DescribeTableRestoreStatusRequestMarshaller
implements Marshaller<Request<DescribeTableRestoreStatusRequest>, DescribeTableRestoreStatusRequest> {
    public Request<DescribeTableRestoreStatusRequest> marshall(DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) {
        if (describeTableRestoreStatusRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeTableRestoreStatusRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeTableRestoreStatus");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTableRestoreStatusRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)describeTableRestoreStatusRequest.clusterIdentifier()));
        }
        if (describeTableRestoreStatusRequest.tableRestoreRequestId() != null) {
            request.addParameter("TableRestoreRequestId", StringConversion.fromString((String)describeTableRestoreStatusRequest.tableRestoreRequestId()));
        }
        if (describeTableRestoreStatusRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeTableRestoreStatusRequest.maxRecords()));
        }
        if (describeTableRestoreStatusRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeTableRestoreStatusRequest.marker()));
        }
        return request;
    }
}

