/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;

public class DescribeHsmConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeHsmConfigurationsRequest>, DescribeHsmConfigurationsRequest> {
    public Request<DescribeHsmConfigurationsRequest> marshall(DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        if (describeHsmConfigurationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeHsmConfigurationsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeHsmConfigurations");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHsmConfigurationsRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringConversion.fromString((String)describeHsmConfigurationsRequest.hsmConfigurationIdentifier()));
        }
        if (describeHsmConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeHsmConfigurationsRequest.maxRecords()));
        }
        if (describeHsmConfigurationsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeHsmConfigurationsRequest.marker()));
        }
        if (describeHsmConfigurationsRequest.tagKeys().isEmpty() && !(describeHsmConfigurationsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeHsmConfigurationsRequest.tagKeys().isEmpty() && !(describeHsmConfigurationsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeHsmConfigurationsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeHsmConfigurationsRequest.tagValues().isEmpty() && !(describeHsmConfigurationsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeHsmConfigurationsRequest.tagValues().isEmpty() && !(describeHsmConfigurationsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeHsmConfigurationsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

