/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;

public class DescribeClusterSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeClusterSnapshotsRequest>, DescribeClusterSnapshotsRequest> {
    public Request<DescribeClusterSnapshotsRequest> marshall(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        if (describeClusterSnapshotsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClusterSnapshotsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterSnapshots");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSnapshotsRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)describeClusterSnapshotsRequest.clusterIdentifier()));
        }
        if (describeClusterSnapshotsRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringConversion.fromString((String)describeClusterSnapshotsRequest.snapshotIdentifier()));
        }
        if (describeClusterSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringConversion.fromString((String)describeClusterSnapshotsRequest.snapshotType()));
        }
        if (describeClusterSnapshotsRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeClusterSnapshotsRequest.startTime()));
        }
        if (describeClusterSnapshotsRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)describeClusterSnapshotsRequest.endTime()));
        }
        if (describeClusterSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeClusterSnapshotsRequest.maxRecords()));
        }
        if (describeClusterSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeClusterSnapshotsRequest.marker()));
        }
        if (describeClusterSnapshotsRequest.ownerAccount() != null) {
            request.addParameter("OwnerAccount", StringConversion.fromString((String)describeClusterSnapshotsRequest.ownerAccount()));
        }
        if (describeClusterSnapshotsRequest.tagKeys().isEmpty() && !(describeClusterSnapshotsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeClusterSnapshotsRequest.tagKeys().isEmpty() && !(describeClusterSnapshotsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeClusterSnapshotsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeClusterSnapshotsRequest.tagValues().isEmpty() && !(describeClusterSnapshotsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeClusterSnapshotsRequest.tagValues().isEmpty() && !(describeClusterSnapshotsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeClusterSnapshotsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        if (describeClusterSnapshotsRequest.clusterExists() != null) {
            request.addParameter("ClusterExists", StringConversion.fromBoolean((Boolean)describeClusterSnapshotsRequest.clusterExists()));
        }
        return request;
    }
}

