/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;

public class DescribeClusterSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterSecurityGroupsRequest>, DescribeClusterSecurityGroupsRequest> {
    public Request<DescribeClusterSecurityGroupsRequest> marshall(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        if (describeClusterSecurityGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClusterSecurityGroupsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterSecurityGroups");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSecurityGroupsRequest.clusterSecurityGroupName() != null) {
            request.addParameter("ClusterSecurityGroupName", StringConversion.fromString((String)describeClusterSecurityGroupsRequest.clusterSecurityGroupName()));
        }
        if (describeClusterSecurityGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeClusterSecurityGroupsRequest.maxRecords()));
        }
        if (describeClusterSecurityGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeClusterSecurityGroupsRequest.marker()));
        }
        if (describeClusterSecurityGroupsRequest.tagKeys().isEmpty() && !(describeClusterSecurityGroupsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeClusterSecurityGroupsRequest.tagKeys().isEmpty() && !(describeClusterSecurityGroupsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeClusterSecurityGroupsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeClusterSecurityGroupsRequest.tagValues().isEmpty() && !(describeClusterSecurityGroupsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeClusterSecurityGroupsRequest.tagValues().isEmpty() && !(describeClusterSecurityGroupsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeClusterSecurityGroupsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

