/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;

public class DescribeClusterParameterGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterParameterGroupsRequest>, DescribeClusterParameterGroupsRequest> {
    public Request<DescribeClusterParameterGroupsRequest> marshall(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        if (describeClusterParameterGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClusterParameterGroupsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterParameterGroups");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterParameterGroupsRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringConversion.fromString((String)describeClusterParameterGroupsRequest.parameterGroupName()));
        }
        if (describeClusterParameterGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeClusterParameterGroupsRequest.maxRecords()));
        }
        if (describeClusterParameterGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeClusterParameterGroupsRequest.marker()));
        }
        if (describeClusterParameterGroupsRequest.tagKeys().isEmpty() && !(describeClusterParameterGroupsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeClusterParameterGroupsRequest.tagKeys().isEmpty() && !(describeClusterParameterGroupsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeClusterParameterGroupsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeClusterParameterGroupsRequest.tagValues().isEmpty() && !(describeClusterParameterGroupsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeClusterParameterGroupsRequest.tagValues().isEmpty() && !(describeClusterParameterGroupsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeClusterParameterGroupsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

