/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;

public class DescribeClusterDbRevisionsRequestMarshaller
implements Marshaller<Request<DescribeClusterDbRevisionsRequest>, DescribeClusterDbRevisionsRequest> {
    public Request<DescribeClusterDbRevisionsRequest> marshall(DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) {
        if (describeClusterDbRevisionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClusterDbRevisionsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterDbRevisions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterDbRevisionsRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)describeClusterDbRevisionsRequest.clusterIdentifier()));
        }
        if (describeClusterDbRevisionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeClusterDbRevisionsRequest.maxRecords()));
        }
        if (describeClusterDbRevisionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeClusterDbRevisionsRequest.marker()));
        }
        return request;
    }
}

