/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateHsmConfigurationRequestMarshaller
implements Marshaller<Request<CreateHsmConfigurationRequest>, CreateHsmConfigurationRequest> {
    public Request<CreateHsmConfigurationRequest> marshall(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        if (createHsmConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createHsmConfigurationRequest, "RedshiftClient");
        request.addParameter("Action", "CreateHsmConfiguration");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createHsmConfigurationRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringConversion.fromString((String)createHsmConfigurationRequest.hsmConfigurationIdentifier()));
        }
        if (createHsmConfigurationRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createHsmConfigurationRequest.description()));
        }
        if (createHsmConfigurationRequest.hsmIpAddress() != null) {
            request.addParameter("HsmIpAddress", StringConversion.fromString((String)createHsmConfigurationRequest.hsmIpAddress()));
        }
        if (createHsmConfigurationRequest.hsmPartitionName() != null) {
            request.addParameter("HsmPartitionName", StringConversion.fromString((String)createHsmConfigurationRequest.hsmPartitionName()));
        }
        if (createHsmConfigurationRequest.hsmPartitionPassword() != null) {
            request.addParameter("HsmPartitionPassword", StringConversion.fromString((String)createHsmConfigurationRequest.hsmPartitionPassword()));
        }
        if (createHsmConfigurationRequest.hsmServerPublicCertificate() != null) {
            request.addParameter("HsmServerPublicCertificate", StringConversion.fromString((String)createHsmConfigurationRequest.hsmServerPublicCertificate()));
        }
        if (createHsmConfigurationRequest.tags().isEmpty() && !(createHsmConfigurationRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createHsmConfigurationRequest.tags().isEmpty() && !(createHsmConfigurationRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createHsmConfigurationRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

