/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateClusterSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateClusterSubnetGroupRequest>, CreateClusterSubnetGroupRequest> {
    public Request<CreateClusterSubnetGroupRequest> marshall(CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) {
        if (createClusterSubnetGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createClusterSubnetGroupRequest, "RedshiftClient");
        request.addParameter("Action", "CreateClusterSubnetGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterSubnetGroupRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringConversion.fromString((String)createClusterSubnetGroupRequest.clusterSubnetGroupName()));
        }
        if (createClusterSubnetGroupRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createClusterSubnetGroupRequest.description()));
        }
        if (createClusterSubnetGroupRequest.subnetIds().isEmpty() && !(createClusterSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SubnetIds", "");
        } else if (!createClusterSubnetGroupRequest.subnetIds().isEmpty() && !(createClusterSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            List<String> subnetIdsList = createClusterSubnetGroupRequest.subnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringConversion.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (createClusterSubnetGroupRequest.tags().isEmpty() && !(createClusterSubnetGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createClusterSubnetGroupRequest.tags().isEmpty() && !(createClusterSubnetGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createClusterSubnetGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

