/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateClusterSnapshotRequestMarshaller
implements Marshaller<Request<CreateClusterSnapshotRequest>, CreateClusterSnapshotRequest> {
    public Request<CreateClusterSnapshotRequest> marshall(CreateClusterSnapshotRequest createClusterSnapshotRequest) {
        if (createClusterSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createClusterSnapshotRequest, "RedshiftClient");
        request.addParameter("Action", "CreateClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringConversion.fromString((String)createClusterSnapshotRequest.snapshotIdentifier()));
        }
        if (createClusterSnapshotRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)createClusterSnapshotRequest.clusterIdentifier()));
        }
        if (createClusterSnapshotRequest.tags().isEmpty() && !(createClusterSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createClusterSnapshotRequest.tags().isEmpty() && !(createClusterSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createClusterSnapshotRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

