/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTarget
implements ToCopyableBuilder<Builder, UpdateTarget> {
    private final String maintenanceTrackName;
    private final String databaseVersion;

    private UpdateTarget(BuilderImpl builder) {
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.databaseVersion = builder.databaseVersion;
    }

    public String maintenanceTrackName() {
        return this.maintenanceTrackName;
    }

    public String databaseVersion() {
        return this.databaseVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTarget)) {
            return false;
        }
        UpdateTarget other = (UpdateTarget)obj;
        return Objects.equals(this.maintenanceTrackName(), other.maintenanceTrackName()) && Objects.equals(this.databaseVersion(), other.databaseVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTarget").add("MaintenanceTrackName", (Object)this.maintenanceTrackName()).add("DatabaseVersion", (Object)this.databaseVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceTrackName": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTrackName()));
            }
            case "DatabaseVersion": {
                return Optional.ofNullable(clazz.cast(this.databaseVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String maintenanceTrackName;
        private String databaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTarget model) {
            this.maintenanceTrackName(model.maintenanceTrackName);
            this.databaseVersion(model.databaseVersion);
        }

        public final String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final String getDatabaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public final Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public final void setDatabaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
        }

        public UpdateTarget build() {
            return new UpdateTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateTarget> {
        public Builder maintenanceTrackName(String var1);

        public Builder databaseVersion(String var1);
    }
}

