/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResizeClusterRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ResizeClusterRequest> {
    private final String clusterIdentifier;
    private final String clusterType;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final Boolean classic;

    private ResizeClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.classic = builder.classic;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String clusterType() {
        return this.clusterType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public Boolean classic() {
        return this.classic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.classic());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResizeClusterRequest)) {
            return false;
        }
        ResizeClusterRequest other = (ResizeClusterRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.clusterType(), other.clusterType()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.classic(), other.classic());
    }

    public String toString() {
        return ToString.builder((String)"ResizeClusterRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ClusterType", (Object)this.clusterType()).add("NodeType", (Object)this.nodeType()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("Classic", (Object)this.classic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "ClusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterType()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "Classic": {
                return Optional.ofNullable(clazz.cast(this.classic()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String clusterType;
        private String nodeType;
        private Integer numberOfNodes;
        private Boolean classic;

        private BuilderImpl() {
        }

        private BuilderImpl(ResizeClusterRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.clusterType(model.clusterType);
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.classic(model.classic);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Boolean getClassic() {
            return this.classic;
        }

        @Override
        public final Builder classic(Boolean classic) {
            this.classic = classic;
            return this;
        }

        public final void setClassic(Boolean classic) {
            this.classic = classic;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResizeClusterRequest build() {
            return new ResizeClusterRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, ResizeClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder clusterType(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder classic(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

