/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EligibleTracksToUpdateListCopier;
import software.amazon.awssdk.services.redshift.model.UpdateTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceTrack
implements ToCopyableBuilder<Builder, MaintenanceTrack> {
    private final String maintenanceTrackName;
    private final String databaseVersion;
    private final List<UpdateTarget> updateTargets;

    private MaintenanceTrack(BuilderImpl builder) {
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.databaseVersion = builder.databaseVersion;
        this.updateTargets = builder.updateTargets;
    }

    public String maintenanceTrackName() {
        return this.maintenanceTrackName;
    }

    public String databaseVersion() {
        return this.databaseVersion;
    }

    public List<UpdateTarget> updateTargets() {
        return this.updateTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTargets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceTrack)) {
            return false;
        }
        MaintenanceTrack other = (MaintenanceTrack)obj;
        return Objects.equals(this.maintenanceTrackName(), other.maintenanceTrackName()) && Objects.equals(this.databaseVersion(), other.databaseVersion()) && Objects.equals(this.updateTargets(), other.updateTargets());
    }

    public String toString() {
        return ToString.builder((String)"MaintenanceTrack").add("MaintenanceTrackName", (Object)this.maintenanceTrackName()).add("DatabaseVersion", (Object)this.databaseVersion()).add("UpdateTargets", this.updateTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceTrackName": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTrackName()));
            }
            case "DatabaseVersion": {
                return Optional.ofNullable(clazz.cast(this.databaseVersion()));
            }
            case "UpdateTargets": {
                return Optional.ofNullable(clazz.cast(this.updateTargets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String maintenanceTrackName;
        private String databaseVersion;
        private List<UpdateTarget> updateTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceTrack model) {
            this.maintenanceTrackName(model.maintenanceTrackName);
            this.databaseVersion(model.databaseVersion);
            this.updateTargets(model.updateTargets);
        }

        public final String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final String getDatabaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public final Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public final void setDatabaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
        }

        public final Collection<UpdateTarget.Builder> getUpdateTargets() {
            return this.updateTargets != null ? (Collection)this.updateTargets.stream().map(UpdateTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updateTargets(Collection<UpdateTarget> updateTargets) {
            this.updateTargets = EligibleTracksToUpdateListCopier.copy(updateTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(UpdateTarget ... updateTargets) {
            this.updateTargets(Arrays.asList(updateTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(Consumer<UpdateTarget.Builder> ... updateTargets) {
            this.updateTargets(Stream.of(updateTargets).map(c -> (UpdateTarget)((UpdateTarget.Builder)UpdateTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateTargets(Collection<UpdateTarget.BuilderImpl> updateTargets) {
            this.updateTargets = EligibleTracksToUpdateListCopier.copyFromBuilder(updateTargets);
        }

        public MaintenanceTrack build() {
            return new MaintenanceTrack(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceTrack> {
        public Builder maintenanceTrackName(String var1);

        public Builder databaseVersion(String var1);

        public Builder updateTargets(Collection<UpdateTarget> var1);

        public Builder updateTargets(UpdateTarget ... var1);

        public Builder updateTargets(Consumer<UpdateTarget.Builder> ... var1);
    }
}

