/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHsmClientCertificateRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CreateHsmClientCertificateRequest> {
    private final String hsmClientCertificateIdentifier;
    private final List<Tag> tags;

    private CreateHsmClientCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.tags = builder.tags;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmClientCertificateRequest)) {
            return false;
        }
        CreateHsmClientCertificateRequest other = (CreateHsmClientCertificateRequest)((Object)obj);
        return Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateHsmClientCertificateRequest").add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmClientCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String hsmClientCertificateIdentifier;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmClientCertificateRequest model) {
            super(model);
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.tags(model.tags);
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHsmClientCertificateRequest build() {
            return new CreateHsmClientCertificateRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, CreateHsmClientCertificateRequest> {
        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

