/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;

public class RestoreFromClusterSnapshotRequestMarshaller
implements Marshaller<Request<RestoreFromClusterSnapshotRequest>, RestoreFromClusterSnapshotRequest> {
    public Request<RestoreFromClusterSnapshotRequest> marshall(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) {
        if (restoreFromClusterSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreFromClusterSnapshotRequest, "RedshiftClient");
        request.addParameter("Action", "RestoreFromClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreFromClusterSnapshotRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.clusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.snapshotIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.snapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.snapshotClusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)restoreFromClusterSnapshotRequest.port()));
        }
        if (restoreFromClusterSnapshotRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.availabilityZone()));
        }
        if (restoreFromClusterSnapshotRequest.allowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringConversion.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.allowVersionUpgrade()));
        }
        if (restoreFromClusterSnapshotRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.clusterSubnetGroupName()));
        }
        if (restoreFromClusterSnapshotRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.publiclyAccessible()));
        }
        if (restoreFromClusterSnapshotRequest.ownerAccount() != null) {
            request.addParameter("OwnerAccount", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.ownerAccount()));
        }
        if (restoreFromClusterSnapshotRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.hsmClientCertificateIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.hsmConfigurationIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.elasticIp() != null) {
            request.addParameter("ElasticIp", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.elasticIp()));
        }
        if (restoreFromClusterSnapshotRequest.clusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.clusterParameterGroupName()));
        }
        if (restoreFromClusterSnapshotRequest.clusterSecurityGroups().isEmpty() && !(restoreFromClusterSnapshotRequest.clusterSecurityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("ClusterSecurityGroups", "");
        } else if (!restoreFromClusterSnapshotRequest.clusterSecurityGroups().isEmpty() && !(restoreFromClusterSnapshotRequest.clusterSecurityGroups() instanceof SdkAutoConstructList)) {
            List<String> clusterSecurityGroupsList = restoreFromClusterSnapshotRequest.clusterSecurityGroups();
            int clusterSecurityGroupsListIndex = 1;
            for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
                if (clusterSecurityGroupsListValue != null) {
                    request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringConversion.fromString((String)clusterSecurityGroupsListValue));
                }
                ++clusterSecurityGroupsListIndex;
            }
        }
        if (restoreFromClusterSnapshotRequest.vpcSecurityGroupIds().isEmpty() && !(restoreFromClusterSnapshotRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!restoreFromClusterSnapshotRequest.vpcSecurityGroupIds().isEmpty() && !(restoreFromClusterSnapshotRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = restoreFromClusterSnapshotRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreFromClusterSnapshotRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.preferredMaintenanceWindow()));
        }
        if (restoreFromClusterSnapshotRequest.automatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringConversion.fromInteger((Integer)restoreFromClusterSnapshotRequest.automatedSnapshotRetentionPeriod()));
        }
        if (restoreFromClusterSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.kmsKeyId()));
        }
        if (restoreFromClusterSnapshotRequest.nodeType() != null) {
            request.addParameter("NodeType", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.nodeType()));
        }
        if (restoreFromClusterSnapshotRequest.enhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringConversion.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.enhancedVpcRouting()));
        }
        if (restoreFromClusterSnapshotRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringConversion.fromString((String)restoreFromClusterSnapshotRequest.additionalInfo()));
        }
        if (restoreFromClusterSnapshotRequest.iamRoles().isEmpty() && !(restoreFromClusterSnapshotRequest.iamRoles() instanceof SdkAutoConstructList)) {
            request.addParameter("IamRoles", "");
        } else if (!restoreFromClusterSnapshotRequest.iamRoles().isEmpty() && !(restoreFromClusterSnapshotRequest.iamRoles() instanceof SdkAutoConstructList)) {
            List<String> iamRolesList = restoreFromClusterSnapshotRequest.iamRoles();
            int iamRolesListIndex = 1;
            for (String iamRolesListValue : iamRolesList) {
                if (iamRolesListValue != null) {
                    request.addParameter("IamRoles.IamRoleArn." + iamRolesListIndex, StringConversion.fromString((String)iamRolesListValue));
                }
                ++iamRolesListIndex;
            }
        }
        return request;
    }
}

