/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;

public class GetClusterCredentialsRequestMarshaller
implements Marshaller<Request<GetClusterCredentialsRequest>, GetClusterCredentialsRequest> {
    public Request<GetClusterCredentialsRequest> marshall(GetClusterCredentialsRequest getClusterCredentialsRequest) {
        if (getClusterCredentialsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getClusterCredentialsRequest, "RedshiftClient");
        request.addParameter("Action", "GetClusterCredentials");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getClusterCredentialsRequest.dbUser() != null) {
            request.addParameter("DbUser", StringConversion.fromString((String)getClusterCredentialsRequest.dbUser()));
        }
        if (getClusterCredentialsRequest.dbName() != null) {
            request.addParameter("DbName", StringConversion.fromString((String)getClusterCredentialsRequest.dbName()));
        }
        if (getClusterCredentialsRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)getClusterCredentialsRequest.clusterIdentifier()));
        }
        if (getClusterCredentialsRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringConversion.fromInteger((Integer)getClusterCredentialsRequest.durationSeconds()));
        }
        if (getClusterCredentialsRequest.autoCreate() != null) {
            request.addParameter("AutoCreate", StringConversion.fromBoolean((Boolean)getClusterCredentialsRequest.autoCreate()));
        }
        if (getClusterCredentialsRequest.dbGroups().isEmpty() && !(getClusterCredentialsRequest.dbGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("DbGroups", "");
        } else if (!getClusterCredentialsRequest.dbGroups().isEmpty() && !(getClusterCredentialsRequest.dbGroups() instanceof SdkAutoConstructList)) {
            List<String> dbGroupsList = getClusterCredentialsRequest.dbGroups();
            int dbGroupsListIndex = 1;
            for (String dbGroupsListValue : dbGroupsList) {
                if (dbGroupsListValue != null) {
                    request.addParameter("DbGroups.DbGroup." + dbGroupsListIndex, StringConversion.fromString((String)dbGroupsListValue));
                }
                ++dbGroupsListIndex;
            }
        }
        return request;
    }
}

